"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputControlVis = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _editor_utils = require("../../editor_utils");
var _list_control = require("./list_control");
var _range_control = require("./range_control");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/input_control_vis/public/components/vis/input_control_vis.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isListControl(control) {
  return control.type === _editor_utils.CONTROL_TYPES.LIST;
}
function isRangeControl(control) {
  return control.type === _editor_utils.CONTROL_TYPES.RANGE;
}
class InputControlVis extends _react.Component {
  constructor(props) {
    super(props);
    this.handleSubmit = this.handleSubmit.bind(this);
    this.handleReset = this.handleReset.bind(this);
    this.handleClearAll = this.handleClearAll.bind(this);
  }
  handleSubmit() {
    this.props.submitFilters();
  }
  handleReset() {
    this.props.resetControls();
  }
  handleClearAll() {
    this.props.clearControls();
  }
  renderControls() {
    return this.props.controls.map((control, index) => {
      let controlComponent = null;
      if (isListControl(control)) {
        controlComponent = /*#__PURE__*/_react.default.createElement(_list_control.ListControl, {
          id: control.id,
          label: control.label,
          options: control.selectOptions,
          selectedOptions: control.value,
          formatOptionLabel: control.format,
          disableMsg: control.isEnabled() ? undefined : control.disabledReason,
          multiselect: control.options.multiselect,
          partialResults: control.partialResults,
          dynamicOptions: control.options.dynamicOptions,
          controlIndex: index,
          stageFilter: this.props.stageFilter,
          fetchOptions: query => {
            this.props.refreshControl(index, query);
          },
          isDarkMode: this.props.isDarkMode,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 11
          }
        });
      } else if (isRangeControl(control)) {
        controlComponent = /*#__PURE__*/_react.default.createElement(_range_control.RangeControl, {
          control: control,
          controlIndex: index,
          stageFilter: this.props.stageFilter,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 93,
            columnNumber: 11
          }
        });
      } else {
        throw new Error(`Unhandled control type ${control.type}`);
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: control.id,
        css: {
          minWidth: '250px'
        },
        "data-test-subj": "inputControlItem",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 9
        }
      }, controlComponent);
    });
  }
  renderStagingButtons() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: this.handleSubmit,
      disabled: !this.props.hasChanges(),
      "data-test-subj": "inputControlSubmitBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inputControl.vis.inputControlVis.applyChangesButtonLabel",
      defaultMessage: "Apply changes",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this.handleReset,
      disabled: !this.props.hasChanges(),
      "data-test-subj": "inputControlCancelBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inputControl.vis.inputControlVis.cancelChangesButtonLabel",
      defaultMessage: "Cancel changes",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this.handleClearAll,
      disabled: !this.props.hasValues(),
      "data-test-subj": "inputControlClearBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inputControl.vis.inputControlVis.clearFormButtonLabel",
      defaultMessage: "Clear form",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 13
      }
    }))));
  }
  render() {
    let stagingButtons;
    if (this.props.controls.length > 0 && !this.props.updateFiltersOnChange) {
      stagingButtons = this.renderStagingButtons();
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-scrollBar",
      css: (0, _react2.css)({
        minHeight: 0,
        flex: '1 1 0',
        display: 'flex',
        overflow: 'auto'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: icvContainerStyles,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    }, this.renderControls()), stagingButtons));
  }
}
exports.InputControlVis = InputControlVis;
const icvContainerStyles = ({
  euiTheme
}) => (0, _react2.css)`
  width: 100%;
  margin: 0 ${euiTheme.size.xs};
  padding: ${euiTheme.size.s};
`;