"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Dissect = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _field_components = require("../field_components");
var _shared_imports = require("../../../../../../shared_imports");
var _field_name_field = require("./common_fields/field_name_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _shared = require("./shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/dissect.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  emptyField
} = _shared_imports.fieldValidators;
const getFieldsConfig = esDocUrl => {
  return {
    /* Required field config */
    pattern: {
      type: _shared_imports.FIELD_TYPES.TEXT,
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dissectForm.patternFieldLabel', {
        defaultMessage: 'Pattern'
      }),
      deserializer: _shared.to.escapeBackslashes,
      serializer: _shared.from.unescapeBackslashes,
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.dissectForm.patternFieldHelpText",
        defaultMessage: "Pattern used to dissect the specified field. The pattern is defined by the parts of the string to discard. Use a {keyModifier} to alter the dissection behavior.",
        values: {
          keyModifier: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            target: "_blank",
            external: true,
            href: esDocUrl,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 46,
              columnNumber: 15
            }
          }, _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dissectForm.patternFieldHelpText.dissectProcessorLink', {
            defaultMessage: 'key modifier'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 9
        }
      }),
      validations: [{
        validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dissectForm.patternRequiredError', {
          defaultMessage: 'A pattern value is required.'
        }))
      }, {
        validator: _shared.isJSONStringValidator
      }]
    },
    /* Optional field config */
    append_separator: {
      type: _shared_imports.FIELD_TYPES.TEXT,
      serializer: _shared.from.emptyStringToUndefined,
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dissectForm.appendSeparatorparaotrFieldLabel', {
        defaultMessage: 'Append separator (optional)'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.dissectForm.appendSeparatorHelpText",
        defaultMessage: "If you specify a key modifier, this character separates the fields when appending results. Defaults to {value}.",
        values: {
          value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 88,
              columnNumber: 28
            }
          }, '""')
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 9
        }
      })
    }
  };
};
const Dissect = () => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const fieldsConfig = getFieldsConfig(services.documentation.getDissectKeyModifiersUrl());
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dissectForm.fieldNameHelpText', {
      defaultMessage: 'Field to dissect.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.pattern,
    component: _field_components.TextEditor,
    componentProps: {
      editorProps: {
        height: _shared.EDITOR_PX_HEIGHT.extraSmall,
        options: {
          minimap: {
            enabled: false
          }
        }
      }
    },
    path: "fields.pattern",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.append_separator,
    component: _shared_imports.Field,
    path: "fields.append_separator",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }));
};
exports.Dissect = Dissect;