"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorOutput = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("../../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processor_output/processor_output.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  tabDescription: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.descriptionText', {
    defaultMessage: 'Preview changes to the test document.'
  }),
  skippedCalloutTitle: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.skippedCalloutTitle', {
    defaultMessage: 'The processor was not run.'
  }),
  droppedCalloutTitle: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.droppedCalloutTitle', {
    defaultMessage: 'The document was dropped.'
  }),
  noOutputCalloutTitle: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.noOutputCalloutTitle', {
    defaultMessage: 'Output is not available for this processor.'
  }),
  processorOutputLabel: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.processorOutputCodeBlockLabel', {
    defaultMessage: 'Data out'
  }),
  processorErrorTitle: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.processorErrorCodeBlockLabel', {
    defaultMessage: 'There was an error'
  }),
  prevProcessorLabel: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.processorInputCodeBlockLabel', {
    defaultMessage: 'Data in'
  }),
  processorIgnoredErrorTitle: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.ignoredErrorCodeBlockLabel', {
    defaultMessage: 'There was an ignored error'
  }),
  documentsDropdownLabel: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.documentsDropdownLabel', {
    defaultMessage: 'Test data:'
  }),
  loadingMessage: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.loadingMessage', {
    defaultMessage: 'Loading processor output…'
  })
};
const styles = {
  callOut: (0, _react2.css)`
    & .euiCallOutHeader {
      align-items: center;
    }
  `,
  codeBlock: (0, _react2.css)`
    & > pre {
      background: transparent;
    }
  `
};
const ProcessorOutput = ({
  processorOutput,
  documents,
  selectedDocumentIndex,
  updateSelectedDocument,
  isExecuting
}) => {
  if (isExecuting) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      inline: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 12
      }
    }, i18nTexts.loadingMessage);
  }
  if (!processorOutput) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18nTexts.noOutputCalloutTitle,
      color: "danger",
      iconType: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 12
      }
    });
  }
  const {
    processorInput,
    doc: currentResult,
    ignored_error: ignoredError,
    error,
    status
  } = processorOutput;
  const NoOutputCallOut = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.noOutputCalloutTitle,
    iconType: "pin",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  });
  const getOutputContent = () => {
    switch (status) {
      case 'skipped':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          title: i18nTexts.skippedCalloutTitle,
          iconType: _shared.SkippedIcon,
          css: styles.callOut,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 129,
            columnNumber: 11
          }
        });
      case 'dropped':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          title: i18nTexts.droppedCalloutTitle,
          iconType: "indexClose",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 136,
            columnNumber: 16
          }
        });
      case 'success':
        if (currentResult) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
            paddingSize: "s",
            language: "json",
            isCopyable: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 140,
              columnNumber: 13
            }
          }, JSON.stringify(currentResult, null, 2));
        }
        return /*#__PURE__*/_react.default.createElement(NoOutputCallOut, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 146,
            columnNumber: 16
          }
        });
      case 'error':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          iconType: _shared.ErrorIcon,
          title: i18nTexts.processorErrorTitle,
          color: "danger",
          css: styles.callOut,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 149,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          language: "json",
          paddingSize: "none",
          css: styles.codeBlock,
          transparentBackground: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 155,
            columnNumber: 13
          }
        }, JSON.stringify(error, null, 2)));
      case 'error_ignored':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          iconType: _shared.ErrorIgnoredIcon,
          title: i18nTexts.processorIgnoredErrorTitle,
          color: "warning",
          css: styles.callOut,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 167,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          css: styles.codeBlock,
          language: "json",
          paddingSize: "none",
          transparentBackground: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 173,
            columnNumber: 13
          }
        }, JSON.stringify(ignoredError, null, 2)));
      default:
        return /*#__PURE__*/_react.default.createElement(NoOutputCallOut, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 184,
            columnNumber: 16
          }
        });
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "processorOutputTabContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, i18nTexts.tabDescription)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    options: documents.map((doc, index) => ({
      value: index,
      text: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.documentLabel', {
        defaultMessage: 'Document {number}',
        values: {
          number: index + 1
        }
      })
    })),
    value: selectedDocumentIndex,
    onChange: e => {
      updateSelectedDocument(Number(e.target.value));
    },
    "aria-label": i18nTexts.documentsDropdownLabel,
    prepend: i18nTexts.documentsDropdownLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "processor_input_accordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 13
      }
    }, i18nTexts.prevProcessorLabel)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    paddingSize: "s",
    language: "json",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 11
    }
  }, JSON.stringify(processorInput ? processorInput : documents[selectedDocumentIndex], null, 2)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 9
    }
  }, i18nTexts.processorOutputLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }), getOutputContent());
};
exports.ProcessorOutput = ProcessorOutput;