"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initFindInventoryViewRoute = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _latest = require("../../../common/http_api/latest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initFindInventoryViewRoute = ({
  framework,
  getStartServices
}) => {
  framework.registerRoute({
    method: 'get',
    path: _latest.INVENTORY_VIEW_URL,
    validate: {
      query: (0, _ioTsUtils.createRouteValidationFunction)(_latest.inventoryViewRequestQueryRT)
    }
  }, async (_requestContext, request, response) => {
    const {
      query
    } = request;
    const [,, {
      inventoryViews
    }] = await getStartServices();
    const inventoryViewsClient = inventoryViews.getScopedClient(request);
    try {
      const inventoryViewsList = await inventoryViewsClient.find(query);
      return response.ok({
        body: _latest.findInventoryViewResponsePayloadRT.encode({
          data: inventoryViewsList
        })
      });
    } catch (error) {
      var _error$statusCode, _error$message;
      return response.customError({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: {
          message: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initFindInventoryViewRoute = initFindInventoryViewRoute;