"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHasDataFromSystemIntegration = exports.getFilteredHostNames = void 0;
var _server = require("@kbn/observability-plugin/server");
var _lodash = require("lodash");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilteredHostNames = async ({
  infraMetricsClient,
  from,
  to,
  limit,
  query,
  schema
}) => {
  var _inventoryModel$nodeF, _inventoryModel$nodeF2, _response$aggregation, _uniqueHostNames$buck, _uniqueHostNames$buck2;
  const inventoryModel = (0, _common.findInventoryModel)('host');
  const response = await infraMetricsClient.search({
    allow_no_indices: true,
    size: 0,
    track_total_hits: false,
    query: {
      bool: {
        filter: [...(0, _lodash.castArray)(query), ...(0, _server.rangeQuery)(from, to), ...((_inventoryModel$nodeF = (_inventoryModel$nodeF2 = inventoryModel.nodeFilter) === null || _inventoryModel$nodeF2 === void 0 ? void 0 : _inventoryModel$nodeF2.call(inventoryModel, {
          schema
        })) !== null && _inventoryModel$nodeF !== void 0 ? _inventoryModel$nodeF : [])]
      }
    },
    aggs: {
      uniqueHostNames: {
        terms: {
          field: _constants.HOST_NAME_FIELD,
          size: limit,
          order: {
            _key: 'asc'
          }
        }
      }
    }
  });
  const {
    uniqueHostNames
  } = (_response$aggregation = response.aggregations) !== null && _response$aggregation !== void 0 ? _response$aggregation : {};
  return (_uniqueHostNames$buck = uniqueHostNames === null || uniqueHostNames === void 0 ? void 0 : (_uniqueHostNames$buck2 = uniqueHostNames.buckets) === null || _uniqueHostNames$buck2 === void 0 ? void 0 : _uniqueHostNames$buck2.map(p => p.key)) !== null && _uniqueHostNames$buck !== void 0 ? _uniqueHostNames$buck : [];
};
exports.getFilteredHostNames = getFilteredHostNames;
const getHasDataFromSystemIntegration = async ({
  infraMetricsClient,
  from,
  to,
  query,
  schema
}) => {
  var _inventoryModel$nodeF3, _inventoryModel$nodeF4;
  const inventoryModel = (0, _common.findInventoryModel)('host');
  const hitCount = await infraMetricsClient.search({
    allow_no_indices: true,
    ignore_unavailable: true,
    size: 0,
    terminate_after: 1,
    track_total_hits: true,
    query: {
      bool: {
        filter: [...(0, _lodash.castArray)(query), ...(0, _server.rangeQuery)(from, to), ...((_inventoryModel$nodeF3 = (_inventoryModel$nodeF4 = inventoryModel.nodeFilter) === null || _inventoryModel$nodeF4 === void 0 ? void 0 : _inventoryModel$nodeF4.call(inventoryModel, {
          schema
        })) !== null && _inventoryModel$nodeF3 !== void 0 ? _inventoryModel$nodeF3 : [])]
      }
    }
  });
  return hitCount.hits.total.value > 0;
};
exports.getHasDataFromSystemIntegration = getHasDataFromSystemIntegration;