"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerBarChart = exports.MetricsExplorerAreaChart = exports.MetricExplorerSeriesChart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _color_palette = require("../../../../../common/color_palette");
var _create_metric_label = require("./helpers/create_metric_label");
var _use_metrics_explorer_options = require("../hooks/use_metrics_explorer_options");
var _use_kibana_time_zone_setting = require("../../../../hooks/use_kibana_time_zone_setting");
var _get_metric_id = require("./helpers/get_metric_id");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metrics_explorer/components/series_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MetricExplorerSeriesChart = props => {
  if (_use_metrics_explorer_options.MetricsExplorerChartType.bar === props.type) {
    return /*#__PURE__*/_react.default.createElement(MetricsExplorerBarChart, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 12
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(MetricsExplorerAreaChart, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 10
    }
  }));
};
exports.MetricExplorerSeriesChart = MetricExplorerSeriesChart;
const MetricsExplorerAreaChart = ({
  metric,
  id,
  series,
  type,
  stack,
  opacity
}) => {
  const timezone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const color = metric.color && (0, _color_palette.colorTransformer)(metric.color) || (0, _color_palette.colorTransformer)(_color_palette.Color.color0);
  const yAccessors = Array.isArray(id) ? id.map(i => (0, _get_metric_id.getMetricId)(metric, i)).slice(id.length - 1, id.length) : [(0, _get_metric_id.getMetricId)(metric, id)];
  const y0Accessors = Array.isArray(id) && id.length > 1 ? id.map(i => (0, _get_metric_id.getMetricId)(metric, i)).slice(0, 1) : undefined;
  const chartId = `series-${series.id}-${yAccessors.join('-')}`;
  const seriesAreaStyle = {
    line: {
      strokeWidth: 2,
      visible: true
    },
    area: {
      opacity: opacity || 0.5,
      visible: type === _use_metrics_explorer_options.MetricsExplorerChartType.area
    }
  };
  return /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: chartId,
    key: chartId,
    name: (0, _create_metric_label.createMetricLabel)(metric)
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "timestamp",
    yAccessors: yAccessors,
    y0Accessors: y0Accessors,
    data: series.rows,
    stackAccessors: stack ? ['timestamp'] : void 0,
    areaSeriesStyle: seriesAreaStyle,
    color: color,
    timeZone: timezone,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  });
};
exports.MetricsExplorerAreaChart = MetricsExplorerAreaChart;
const MetricsExplorerBarChart = ({
  metric,
  id,
  series,
  stack
}) => {
  const timezone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const color = metric.color && (0, _color_palette.colorTransformer)(metric.color) || (0, _color_palette.colorTransformer)(_color_palette.Color.color0);
  const yAccessors = Array.isArray(id) ? id.map(i => (0, _get_metric_id.getMetricId)(metric, i)).slice(id.length - 1, id.length) : [(0, _get_metric_id.getMetricId)(metric, id)];
  const chartId = `series-${series.id}-${yAccessors.join('-')}`;
  const seriesBarStyle = {
    rectBorder: {
      stroke: color,
      strokeWidth: 1,
      visible: true
    },
    rect: {
      opacity: 1
    }
  };
  return /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: chartId,
    key: chartId,
    name: (0, _create_metric_label.createMetricLabel)(metric)
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "timestamp",
    yAccessors: yAccessors,
    data: series.rows,
    stackAccessors: stack ? ['timestamp'] : void 0,
    barSeriesStyle: seriesBarStyle,
    color: color,
    timeZone: timezone,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  });
};
exports.MetricsExplorerBarChart = MetricsExplorerBarChart;