"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateDomain = void 0;
var _lodash = require("lodash");
var _get_metric_id = require("./get_metric_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMin = values => {
  const minValue = (0, _lodash.min)(values);
  return (0, _lodash.isNumber)(minValue) && Number.isFinite(minValue) ? minValue : undefined;
};
const getMax = values => {
  const maxValue = (0, _lodash.max)(values);
  return (0, _lodash.isNumber)(maxValue) && Number.isFinite(maxValue) ? maxValue : undefined;
};
const calculateDomain = (series, metrics, stacked = false) => {
  const values = series.rows.reduce((acc, row) => {
    const rowValues = metrics.map((m, index) => {
      return row[(0, _get_metric_id.getMetricId)(m, index)] || null;
    }).filter(v => (0, _lodash.isNumber)(v));
    const minValue = getMin(rowValues);
    // For stacked domains we want to add 10% head room so the charts have
    // enough room to draw the 2 pixel line as well.
    const maxValue = stacked ? (0, _lodash.sum)(rowValues) * 1.1 : getMax(rowValues);
    return acc.concat([minValue || null, maxValue || null]);
  }, []).filter(v => (0, _lodash.isNumber)(v));
  return {
    min: getMin(values) || 0,
    max: getMax(values) || 0
  };
};
exports.calculateDomain = calculateDomain;