"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepLegend = void 0;
var _polished = require("polished");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _types = require("../../../../../common/inventory/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/steps_legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OPERATORS = {
  [_types.InfraWaffleMapRuleOperator.gte]: '>=',
  [_types.InfraWaffleMapRuleOperator.gt]: '>',
  [_types.InfraWaffleMapRuleOperator.lte]: '<=',
  [_types.InfraWaffleMapRuleOperator.lt]: '<',
  [_types.InfraWaffleMapRuleOperator.eq]: '='
};
const createStep = formatter => (rule, index) => {
  const label = rule.label != null ? rule.label : `${OPERATORS[rule.operator]} ${formatter(rule.value)}`;
  const squareStyle = {
    backgroundColor: (0, _polished.darken)(0.4, rule.color)
  };
  const squareInnerStyle = {
    backgroundColor: rule.color
  };
  return /*#__PURE__*/_react.default.createElement(StepContainer, {
    key: `legend-step-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(StepSquare, {
    style: squareStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StepSquareInner, {
    style: squareInnerStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(StepLabel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, label));
};
const StepLegend = ({
  legend,
  formatter
}) => {
  return /*#__PURE__*/_react.default.createElement(StepLegendContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 10
    }
  }, legend.rules.map(createStep(formatter)));
};
exports.StepLegend = StepLegend;
const StepLegendContainer = _styled.default.div`
  display: flex;
  padding: 10px 40px 10px 10px;
`;
const StepContainer = _styled.default.div`
  display: flex;
  margin-right: 20px
  align-items: center;
`;
const StepSquare = _styled.default.div`
  position: relative;
  width: 24px;
  height: 24px;
  flex: 0 0 auto;
  margin-right: 5px;
  border-radius: 3px;
  box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.2);
`;
const StepSquareInner = _styled.default.div`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 2px;
  border-radius: 3px;
`;
const StepLabel = _styled.default.div`
  font-size: ${() => (0, _eui.useEuiFontSize)('xs').fontSize};
`;