"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsAndGroupByToolbarItems = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _use_time_range_metadata = require("../../../../../hooks/use_time_range_metadata");
var _schema_selector = require("../../../../../components/schema_selector");
var _snapshot_metric_i18n = require("../../../../../../common/snapshot_metric_i18n");
var _metric_control = require("../waffle/metric_control");
var _waffle_group_by_controls = require("../waffle/waffle_group_by_controls");
var _waffle_sort_controls = require("../waffle/waffle_sort_controls");
var _supported_data_tooltip_link = require("../../../../../components/supported_data_tooltip_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/toolbars/metrics_and_groupby_toolbar_items.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricsAndGroupByToolbarItems = ({
  preferredSchema,
  changePreferredSchema,
  allowSchemaSelection = false,
  ...props
}) => {
  const inventoryModel = (0, _common.findInventoryModel)(props.nodeType);
  const {
    data: timeRangeMetadata,
    loading = false
  } = (0, _use_time_range_metadata.useTimeRangeMetadataContext)();
  const schemas = (0, _react.useMemo)(() => (timeRangeMetadata === null || timeRangeMetadata === void 0 ? void 0 : timeRangeMetadata.schemas) || [], [timeRangeMetadata === null || timeRangeMetadata === void 0 ? void 0 : timeRangeMetadata.schemas]);
  (0, _react.useEffect)(() => {
    if (!allowSchemaSelection || !(timeRangeMetadata !== null && timeRangeMetadata !== void 0 && timeRangeMetadata.preferredSchema) || schemas.length === 0) {
      return;
    }
    if (preferredSchema === null) {
      changePreferredSchema(timeRangeMetadata.preferredSchema);
    }
  }, [allowSchemaSelection, changePreferredSchema, preferredSchema, schemas, timeRangeMetadata === null || timeRangeMetadata === void 0 ? void 0 : timeRangeMetadata.preferredSchema]);
  const {
    value: aggregations
  } = (0, _useAsync.default)(() => inventoryModel.metrics.getAggregations({
    schema: preferredSchema !== null && preferredSchema !== void 0 ? preferredSchema : 'ecs'
  }), [inventoryModel.metrics, preferredSchema]);
  const metricOptions = (0, _react.useMemo)(() => {
    var _aggregations$getAll;
    return Object.keys((_aggregations$getAll = aggregations === null || aggregations === void 0 ? void 0 : aggregations.getAll()) !== null && _aggregations$getAll !== void 0 ? _aggregations$getAll : {}).map(metric => (0, _snapshot_metric_i18n.toMetricOpt)(metric, props.nodeType)).filter(v => v);
  }, [aggregations, props.nodeType]);
  const groupByOptions = (0, _react.useMemo)(() => props.groupByFields.map(field => ({
    text: field,
    field
  })), [props.groupByFields]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_metric_control.WaffleMetricControls, {
    options: metricOptions,
    metric: props.metric,
    onChange: props.changeMetric,
    onChangeCustomMetrics: props.changeCustomMetrics,
    customMetrics: props.customMetrics,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_waffle_group_by_controls.WaffleGroupByControls, {
    options: groupByOptions,
    groupBy: props.groupBy,
    nodeType: props.nodeType,
    onChange: props.changeGroupBy,
    onChangeCustomOptions: props.changeCustomOptions,
    customOptions: props.customOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  })), props.view === 'map' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_waffle_sort_controls.WaffleSortControls, {
    sort: props.sort,
    onChange: props.changeSort,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  })), allowSchemaSelection && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_schema_selector.SchemaSelector, {
    value: preferredSchema !== null && preferredSchema !== void 0 ? preferredSchema : 'semconv',
    schemas: schemas,
    isLoading: loading,
    onChange: changePreferredSchema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_supported_data_tooltip_link.SupportedDataTooltipLink, {
    nodeType: props.nodeType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  })));
};
exports.MetricsAndGroupByToolbarItems = MetricsAndGroupByToolbarItems;