"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timeline = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_timeline_chart_theme = require("../../../../../hooks/use_timeline_chart_theme");
var _snapshot_metric_i18n = require("../../../../../../common/snapshot_metric_i18n");
var _color_palette = require("../../../../../../common/color_palette");
var _metrics_source = require("../../../../../containers/metrics_source");
var _use_timeline = require("../../hooks/use_timeline");
var _use_waffle_options = require("../../hooks/use_waffle_options");
var _use_waffle_time = require("../../hooks/use_waffle_time");
var _use_waffle_filters = require("../../hooks/use_waffle_filters");
var _series_chart = require("../../../metrics_explorer/components/series_chart");
var _use_metrics_explorer_options = require("../../../metrics_explorer/hooks/use_metrics_explorer_options");
var _calculate_domain = require("../../../metrics_explorer/components/helpers/calculate_domain");
var _use_metrics_hosts_anomalies = require("../../hooks/use_metrics_hosts_anomalies");
var _use_metrics_k8s_anomalies = require("../../hooks/use_metrics_k8s_anomalies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/timeline/timeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Timeline = ({
  interval,
  yAxisFormatter,
  isVisible
}) => {
  var _toMetricOpt, _toMetricOpt2;
  const {
    sourceId,
    source
  } = (0, _metrics_source.useSourceContext)();
  const {
    metric,
    nodeType,
    accountId,
    region,
    preferredSchema
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    currentTime,
    jumpToTime,
    stopAutoReload
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    filterQuery
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartTheme = (0, _use_timeline_chart_theme.useTimelineChartTheme)();
  const {
    loading,
    error,
    startTime,
    endTime,
    timeseries,
    reload
  } = (0, _use_timeline.useTimeline)({
    kuery: filterQuery.query,
    metrics: [metric],
    nodeType,
    sourceId,
    currentTime,
    accountId,
    region,
    interval,
    shouldReload: isVisible
  });
  const anomalyMetricName = (0, _react.useMemo)(() => {
    const metricType = metric.type;
    switch (metricType) {
      case 'memory':
        return 'memory_usage';
      case 'rx':
        return 'network_in';
      case 'tx':
        return 'network_out';
      default:
        return;
    }
  }, [metric]);
  const anomalyParams = {
    sourceId: 'default',
    anomalyThreshold: (source === null || source === void 0 ? void 0 : source.configuration.anomalyThreshold) || 0,
    startTime,
    endTime,
    defaultSortOptions: {
      direction: 'desc',
      field: 'anomalyScore'
    },
    defaultPaginationOptions: {
      pageSize: 100
    },
    metric: anomalyMetricName
  };
  const {
    metricsHostsAnomalies
  } = (0, _use_metrics_hosts_anomalies.useMetricsHostsAnomaliesResults)({
    ...anomalyParams,
    schema: preferredSchema !== null && preferredSchema !== void 0 ? preferredSchema : 'ecs'
  }, {
    active: nodeType === 'host'
  });
  const {
    metricsK8sAnomalies
  } = (0, _use_metrics_k8s_anomalies.useMetricsK8sAnomaliesResults)(anomalyParams, {
    active: nodeType === 'pod'
  });
  const anomalies = (0, _react.useMemo)(() => {
    if (preferredSchema === 'semconv') {
      return;
    }
    if (nodeType === 'host') {
      return metricsHostsAnomalies;
    } else if (nodeType === 'pod') {
      return metricsK8sAnomalies;
    }
  }, [preferredSchema, nodeType, metricsHostsAnomalies, metricsK8sAnomalies]);
  const metricLabel = (_toMetricOpt = (0, _snapshot_metric_i18n.toMetricOpt)(metric.type, nodeType)) === null || _toMetricOpt === void 0 ? void 0 : _toMetricOpt.textLC;
  const metricPopoverLabel = (_toMetricOpt2 = (0, _snapshot_metric_i18n.toMetricOpt)(metric.type, nodeType)) === null || _toMetricOpt2 === void 0 ? void 0 : _toMetricOpt2.text;
  const chartMetric = {
    color: _color_palette.Color.color0,
    aggregation: 'avg',
    label: metricPopoverLabel
  };
  const dateFormatter = (0, _react.useMemo)(() => {
    var _first, _last;
    if (!timeseries) return () => '';
    const firstTimestamp = (_first = (0, _lodash.first)(timeseries.rows)) === null || _first === void 0 ? void 0 : _first.timestamp;
    const lastTimestamp = (_last = (0, _lodash.last)(timeseries.rows)) === null || _last === void 0 ? void 0 : _last.timestamp;
    if (firstTimestamp == null || lastTimestamp == null) {
      return value => `${value}`;
    }
    return (0, _charts.niceTimeFormatter)([firstTimestamp, lastTimestamp]);
  }, [timeseries]);
  const tooltipProps = {
    headerFormatter: ({
      value
    }) => (0, _moment.default)(value).format('Y-MM-DD HH:mm:ss.SSS')
  };
  const dataDomain = timeseries ? (0, _calculate_domain.calculateDomain)(timeseries, [chartMetric], false) : null;
  const domain = dataDomain ? {
    max: dataDomain.max * 1.1,
    // add 10% headroom.
    min: dataDomain.min
  } : {
    max: 0,
    min: 0
  };
  const onClickPoint = (0, _react.useCallback)(([elementEvent]) => {
    // casting to GeometryValue as we are using cartesian charts
    const [geometryValue] = elementEvent;
    if (geometryValue && !Array.isArray(geometryValue)) {
      const {
        x: timestamp
      } = geometryValue;
      jumpToTime(timestamp);
      stopAutoReload();
    }
  }, [jumpToTime, stopAutoReload]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(TimelineContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(TimelineLoadingContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 11
      }
    })));
  }
  if (!loading && (error || !timeseries)) {
    return /*#__PURE__*/_react.default.createElement(TimelineContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "visArea",
      title: /*#__PURE__*/_react.default.createElement("h4", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 18
        }
      }, error ? errorTitle : noHistoryDataTitle),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "infraTimelineButton",
        color: "primary",
        fill: true,
        onClick: reload,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 13
        }
      }, error ? retryButtonLabel : checkNewDataButtonLabel),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 9
      }
    }));
  }
  function generateAnnotationData(results) {
    return results.map(anomaly => {
      const [val, influencers] = anomaly;
      return {
        coordinates: {
          x0: val,
          x1: (0, _moment.default)(val).add(15, 'minutes').valueOf(),
          y0: dataDomain === null || dataDomain === void 0 ? void 0 : dataDomain.min,
          y1: dataDomain === null || dataDomain === void 0 ? void 0 : dataDomain.max
        },
        details: influencers.join(',')
      };
    });
  }
  return /*#__PURE__*/_react.default.createElement(TimelineContainer, {
    "data-test-subj": isVisible ? 'timelineContainerOpen' : 'timelineContainerClosed',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(TimelineHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.inventoryTimeline.header",
    defaultMessage: "Average {metricLabel}",
    values: {
      metricLabel
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's',
    alignItems: 'center',
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: (0, _color_palette.colorTransformer)(chartMetric.color),
    type: 'dot',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.inventoryTimeline.header",
    defaultMessage: "Average {metricLabel}",
    values: {
      metricLabel
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 21
    }
  }))))), preferredSchema !== 'semconv' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's',
    alignItems: 'center',
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      backgroundColor: euiTheme.colors.backgroundFilledAccent,
      height: 5,
      width: 10
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.inventoryTimeline.legend.anomalyLabel",
    defaultMessage: "Anomaly detected",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 23
    }
  }))))) : null))), /*#__PURE__*/_react.default.createElement(TimelineChartContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 9
    }
  }, anomalies && /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: 'anomalies',
    dataValues: generateAnnotationData(anomalies.map(a => [a.startTime, a.influencers])),
    style: {
      fill: euiTheme.colors.backgroundFilledAccent
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_series_chart.MetricExplorerSeriesChart, {
    type: _use_metrics_explorer_options.MetricsExplorerChartType.area,
    metric: chartMetric,
    id: "0",
    series: timeseries,
    stack: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'timestamp',
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'values',
    position: _charts.Position.Left,
    tickFormat: yAxisFormatter,
    domain: domain,
    ticks: 6,
    gridLine: {
      visible: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, (0, _extends2.default)({}, tooltipProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    onElementClick: onClickPoint,
    baseTheme: chartTheme.baseTheme,
    theme: chartTheme.theme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 11
    }
  }))));
};
exports.Timeline = Timeline;
const TimelineContainer = _styled.default.div`
  background-color: ${props => props.theme.euiTheme.colors.body};
  border-top: 1px solid ${props => props.theme.euiTheme.colors.lightShade};
  height: 220px;
  width: 100%;
  padding: ${props => props.theme.euiTheme.size.s} ${props => props.theme.euiTheme.size.m};
  display: flex;
  flex-direction: column;
`;
const TimelineHeader = _styled.default.div`
  display: flex;
  width: 100%;
  padding: ${props => props.theme.euiTheme.size.s} ${props => props.theme.euiTheme.size.m};
  @media only screen and (max-width: 767px) {
    margin-top: 30px;
  }
`;
const TimelineChartContainer = _styled.default.div`
  padding-left: ${props => props.theme.euiTheme.size.xs};
  width: 100%;
  height: 100%;
`;
const TimelineLoadingContainer = _styled.default.div`
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100%;
`;
const noHistoryDataTitle = _i18n.i18n.translate('xpack.infra.inventoryTimeline.noHistoryDataTitle', {
  defaultMessage: 'There is no historical data to display.'
});
const errorTitle = _i18n.i18n.translate('xpack.infra.inventoryTimeline.errorTitle', {
  defaultMessage: 'Unable to show historical data.'
});
const checkNewDataButtonLabel = _i18n.i18n.translate('xpack.infra.inventoryTimeline.checkNewDataButtonLabel', {
  defaultMessage: 'Check for new data'
});
const retryButtonLabel = _i18n.i18n.translate('xpack.infra.inventoryTimeline.retryButtonLabel', {
  defaultMessage: 'Try again'
});