"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTabBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../../../../common/constants");
var _use_alerts_count = require("../../../../../hooks/use_alerts_count");
var _use_alerts_query = require("../../hooks/use_alerts_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/tabs/alerts_tab_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertsTabBadge = () => {
  const {
    alertsEsQuery
  } = (0, _use_alerts_query.useAlertsQuery)();
  const {
    alertsCount,
    loading,
    error
  } = (0, _use_alerts_count.useAlertsCount)({
    ruleTypeIds: _ruleDataUtils.OBSERVABILITY_RULE_TYPE_IDS,
    consumers: _constants.INFRA_ALERT_CONSUMERS,
    query: alertsEsQuery
  });
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 12
      }
    });
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.alerts.countError', {
        defaultMessage: 'The active alert count was not retrieved correctly, try reloading the page.'
      }),
      type: "warning",
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 7
      }
    });
  }
  const shouldRenderBadge = typeof (alertsCount === null || alertsCount === void 0 ? void 0 : alertsCount.activeAlertCount) === 'number' && alertsCount.activeAlertCount > 0;
  return shouldRenderBadge ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "danger",
    className: "eui-alignCenter",
    "data-test-subj": "hostsView-tabs-alerts-count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, alertsCount === null || alertsCount === void 0 ? void 0 : alertsCount.activeAlertCount) : null;
};
exports.AlertsTabBadge = AlertsTabBadge;