"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetActionsList = void 0;
var _react = _interopRequireDefault(require("react"));
var _log_analysis = require("../../../../../../common/log_analysis");
var _analyze_dataset_in_ml_action = require("./analyze_dataset_in_ml_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_categories/sections/top_categories/datasets_action_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DatasetActionsList = ({
  categorizationJobId,
  categoryId,
  datasets,
  timeRange
}) => /*#__PURE__*/_react.default.createElement("ul", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 3
  }
}, datasets.map(dataset => {
  const datasetLabel = (0, _log_analysis.getFriendlyNameForPartitionId)(dataset.name);
  return /*#__PURE__*/_react.default.createElement("li", {
    key: datasetLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_analyze_dataset_in_ml_action.AnalyzeCategoryDatasetInMlAction, {
    categorizationJobId: categorizationJobId,
    categoryId: categoryId,
    dataset: dataset.name,
    timeRange: timeRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 11
    }
  }));
}));
exports.DatasetActionsList = DatasetActionsList;