"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaginationControls = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/ml/anomaly_detection/anomalies_table/pagination.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const previousPageLabel = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTablePreviousPageLabel', {
  defaultMessage: 'Previous page'
});
const nextPageLabel = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTableNextPageLabel', {
  defaultMessage: 'Next page'
});
const PaginationControls = ({
  fetchPreviousPage,
  fetchNextPage,
  page,
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraPaginationControlsButton",
    iconType: "arrowLeft",
    isDisabled: !fetchPreviousPage || isLoading,
    onClick: fetchPreviousPage,
    "aria-label": previousPageLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 13
    }
  }, page)), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraPaginationControlsButton",
    iconType: "arrowRight",
    isDisabled: !fetchNextPage || isLoading,
    onClick: fetchNextPage,
    "aria-label": nextPageLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }))));
};
exports.PaginationControls = PaginationControls;