"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobDefinitionOutdatedCallout = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _recreate_job_callout = require("./recreate_job_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_job_status/job_definition_outdated_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const JobDefinitionOutdatedCallout = ({
  hasSetupCapabilities,
  moduleName,
  onRecreateMlJob
}) => /*#__PURE__*/_react.default.createElement(_recreate_job_callout.RecreateJobCallout, {
  hasSetupCapabilities: hasSetupCapabilities,
  title: _i18n.i18n.translate('xpack.infra.logs.analysis.jobDefinitionOutdatedCalloutTitle', {
    defaultMessage: 'The {moduleName} ML job definition is outdated',
    values: {
      moduleName
    }
  }),
  onRecreateMlJob: onRecreateMlJob,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 19,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.analysis.jobDefinitionOutdatedCalloutMessage",
  defaultMessage: "A newer version of the {moduleName} ML job is available. Recreate the job to deploy the newer version. This removes previously detected anomalies.",
  values: {
    moduleName
  },
  tagName: "p",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 5
  }
}));
exports.JobDefinitionOutdatedCallout = JobDefinitionOutdatedCallout;