"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntersectingState = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIntersectingState = (ref, currentState) => {
  const [intersectionObserverEntry, setIntersectionObserverEntry] = (0, _react.useState)();
  const curState = (0, _react.useRef)(currentState);
  const observerRef = (0, _react.useRef)(new IntersectionObserver(([value]) => setIntersectionObserverEntry(value), {
    root: ref.current
  }));
  (0, _react.useEffect)(() => {
    const {
      current: currentObserver
    } = observerRef;
    currentObserver.disconnect();
    const {
      current
    } = ref;
    if (current) {
      currentObserver.observe(current);
    }
    return () => currentObserver.disconnect();
  }, [ref]);
  if (intersectionObserverEntry !== null && intersectionObserverEntry !== void 0 && intersectionObserverEntry.isIntersecting) {
    curState.current = currentState;
  }
  return curState.current;
};
exports.useIntersectingState = useIntersectingState;