"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateChartRowsTimeInterval = calculateChartRowsTimeInterval;
exports.extractRangeFromChartFilterEvent = extractRangeFromChartFilterEvent;
exports.extractTableEntryFromChartClickContextData = extractTableEntryFromChartClickContextData;
exports.isChartClickContextData = isChartClickContextData;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isChartClickContextData(data) {
  var _data$;
  return Array.isArray(data) && Array.isArray((_data$ = data[0]) === null || _data$ === void 0 ? void 0 : _data$.cells) && data[0].cells.length > 0;
}
function calculateChartRowsTimeInterval(rows, timestampColumnId) {
  if (rows.length < 2) {
    return 0;
  }
  return Math.abs(rows[1][timestampColumnId] - rows[0][timestampColumnId]);
}
function extractTableEntryFromChartClickContextData(data) {
  var _table$columns$cell$c, _table$rows$cell$row;
  const table = data[0].table;
  const cell = data[0].cells[0];
  const column = (_table$columns$cell$c = table.columns[cell.column]) !== null && _table$columns$cell$c !== void 0 ? _table$columns$cell$c : null;
  const row = (_table$rows$cell$row = table.rows[cell.row]) !== null && _table$rows$cell$row !== void 0 ? _table$rows$cell$row : null;
  return {
    column,
    row
  };
}
function extractRangeFromChartFilterEvent({
  data
}) {
  if (!isChartClickContextData(data)) {
    return null;
  }
  const {
    column,
    row
  } = extractTableEntryFromChartClickContextData(data);
  if (!column || !row || column.meta.type !== 'date') {
    return null;
  }
  const timestamp = row[column.id];
  const rowInterval = calculateChartRowsTimeInterval(data[0].table.rows, column.id);
  const from = new Date(timestamp).toISOString();
  const to = new Date(timestamp + rowInterval).toISOString();
  return {
    from,
    to
  };
}