"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleFormat = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lodash = require("lodash");
var _alert_link = require("../../../common/alerting/metrics/alert_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleFormat = ({
  assetDetailsLocator,
  metricsExplorerLocator
}) => {
  return ({
    fields
  }) => {
    var _fields$ALERT_REASON;
    const reason = (_fields$ALERT_REASON = fields[_ruleDataUtils.ALERT_REASON]) !== null && _fields$ALERT_REASON !== void 0 ? _fields$ALERT_REASON : '-';
    const parameters = fields[_ruleDataUtils.ALERT_RULE_PARAMETERS];
    const link = (0, _alert_link.getMetricsViewInAppUrl)({
      fields,
      groupBy: (0, _lodash.castArray)(parameters === null || parameters === void 0 ? void 0 : parameters.groupBy),
      assetDetailsLocator,
      metricsExplorerLocator
    });
    return {
      reason,
      link,
      hasBasePath: true
    };
  };
};
exports.getRuleFormat = getRuleFormat;