"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LangfuseSpanProcessor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _exporterTraceOtlpHttp = require("@opentelemetry/exporter-trace-otlp-http");
var _lodash = require("lodash");
var _api = require("@opentelemetry/api");
var _base_inference_span_processor = require("../base_inference_span_processor");
var _unflatten_attributes = require("../util/unflatten_attributes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LangfuseSpanProcessor extends _base_inference_span_processor.BaseInferenceSpanProcessor {
  constructor(config) {
    const headers = {
      Authorization: `Basic ${Buffer.from(`${config.public_key}:${config.secret_key}`).toString('base64')}`
    };
    const exporter = new _exporterTraceOtlpHttp.OTLPTraceExporter({
      url: `${config.base_url}/api/public/otel/v1/traces`,
      headers
    });
    super(exporter, config.scheduled_delay);
    (0, _defineProperty2.default)(this, "getProjectId", void 0);
    this.config = config;
    const getProjectIdMemoized = (0, _lodash.memoize)(async () => {
      var _data$;
      const base = new URL(config.base_url);
      const {
        data
      } = await fetch(new URL('/api/public/projects', base), {
        headers
      }).then(response => response.json());
      return data === null || data === void 0 ? void 0 : (_data$ = data[0]) === null || _data$ === void 0 ? void 0 : _data$.id;
    });
    this.getProjectId = () => {
      return getProjectIdMemoized().catch(error => {
        var _getProjectIdMemoized, _getProjectIdMemoized2;
        _api.diag.error(`Could not get project ID from Langfuse: ${error.message}`);
        (_getProjectIdMemoized = (_getProjectIdMemoized2 = getProjectIdMemoized.cache).clear) === null || _getProjectIdMemoized === void 0 ? void 0 : _getProjectIdMemoized.call(_getProjectIdMemoized2);
        return undefined;
      });
    };
  }
  processInferenceSpan(span) {
    // Langfuse doesn't understand fully semconv-compliant span events
    // yet, so we translate to a format it does understand. see
    // https://github.com/langfuse/langfuse/blob/c1c22a9b9b684bd45ca9436556c2599d5a23271d/web/src/features/otel/server/index.ts#L476
    if (span.attributes['gen_ai.operation.name'] === 'chat') {
      const [inputEvents, outputEvents] = (0, _lodash.partition)(span.events, event => event.name !== 'gen_ai.choice');
      span.attributes['input.value'] = JSON.stringify(inputEvents.map(event => {
        var _event$attributes;
        return (0, _unflatten_attributes.unflattenAttributes)((_event$attributes = event.attributes) !== null && _event$attributes !== void 0 ? _event$attributes : {});
      }));
      span.attributes['output.value'] = JSON.stringify(outputEvents.map(event => {
        var _event$attributes2;
        const {
          message,
          ...rest
        } = (0, _unflatten_attributes.unflattenAttributes)((_event$attributes2 = event.attributes) !== null && _event$attributes2 !== void 0 ? _event$attributes2 : {});
        return {
          ...(0, _lodash.omit)(rest, 'finish_reason', 'index'),
          ...message
        };
      })[0]);
    }
    if (!span.parentSpanContext) {
      const traceId = span.spanContext().traceId;
      void this.getProjectId().then(projectId => {
        // this is how Langfuse generates IDs, see
        // https://github.com/langfuse/langfuse/blob/2d4708921c67bca61c774633b7df65b3c5105f0d/web/src/features/otel/server/index.ts#L506
        const langfuseTraceId = Buffer.from(traceId).toString('hex');
        const url = new URL(`/project/${projectId}/traces/${langfuseTraceId}`, new URL(this.config.base_url));
        _api.diag.info(`View trace at ${url.toString()}`);
      });
    }
    return span;
  }
}
exports.LangfuseSpanProcessor = LangfuseSpanProcessor;