"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCompleteToolCall = createCompleteToolCall;
exports.createCompleteToolCallResponse = createCompleteToolCallResponse;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMPLETE_INSTRUCTIONS = `Enter into your Definitive Output mode.`;
function createCompleteToolCallResponse(toolCallId) {
  return {
    role: _inferenceCommon.MessageRole.Tool,
    toolCallId,
    name: 'complete',
    response: {
      acknowledged: true,
      instructions: COMPLETE_INSTRUCTIONS
    }
  };
}
function createCompleteToolCall() {
  const toolCallId = (0, _inferenceCommon.generateFakeToolCallId)();
  return [{
    role: _inferenceCommon.MessageRole.Assistant,
    content: '',
    toolCalls: [{
      function: {
        name: 'complete',
        arguments: {}
      },
      toolCallId
    }]
  }, createCompleteToolCallResponse(toolCallId)];
}