"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferencePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _inferenceCommon = require("@kbn/inference-common");
var _inference_client = require("./inference_client");
var _regex_worker_service = require("./chat_complete/anonymization/regex_worker_service");
var _routes = require("./routes");
var _ui_settings = require("../common/ui_settings");
var _get_connector_list = require("./util/get_connector_list");
var _load_default_connector = require("./util/load_default_connector");
var _get_connector_by_id = require("./util/get_connector_by_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InferencePlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "regexWorker", void 0);
    this.logger = context.logger.get();
    this.config = context.config.get();
  }
  setup(coreSetup, pluginsSetup) {
    coreSetup.uiSettings.register(_ui_settings.uiSettings);
    const router = coreSetup.http.createRouter();
    (0, _routes.registerRoutes)({
      router,
      coreSetup,
      logger: this.logger
    });
    return {};
  }
  start(core, pluginsStart) {
    this.regexWorker = new _regex_worker_service.RegexWorkerService(this.config.workers.anonymization, this.logger.get('regex_worker'));
    const createAnonymizationRulesPromise = async request => {
      const soClient = core.savedObjects.getScopedClient(request);
      const uiSettingsClient = core.uiSettings.asScopedToClient(soClient);
      const settingsStr = await uiSettingsClient.get(_inferenceCommon.aiAnonymizationSettings);
      if (!settingsStr) {
        return [];
      }
      try {
        const settings = JSON.parse(settingsStr);
        return settings.rules || [];
      } catch (error) {
        this.logger.error('Failed to parse anonymization settings:', error);
        return [];
      }
    };
    return {
      getClient: options => {
        return (0, _inference_client.createClient)({
          ...options,
          anonymizationRulesPromise: createAnonymizationRulesPromise(options.request),
          regexWorker: this.regexWorker,
          actions: pluginsStart.actions,
          logger: this.logger.get('client'),
          esClient: core.elasticsearch.client.asScoped(options.request).asCurrentUser
        });
      },
      getChatModel: async options => {
        return (0, _inference_client.createChatModel)({
          request: options.request,
          connectorId: options.connectorId,
          chatModelOptions: options.chatModelOptions,
          actions: pluginsStart.actions,
          anonymizationRulesPromise: createAnonymizationRulesPromise(options.request),
          regexWorker: this.regexWorker,
          esClient: core.elasticsearch.client.asScoped(options.request).asCurrentUser,
          logger: this.logger
        });
      },
      getConnectorList: async request => {
        return (0, _get_connector_list.getConnectorList)({
          actions: pluginsStart.actions,
          request
        });
      },
      getDefaultConnector: async request => {
        return (0, _load_default_connector.loadDefaultConnector)({
          actions: pluginsStart.actions,
          request
        });
      },
      getConnectorById: async (id, request) => {
        return (0, _get_connector_by_id.getConnectorById)({
          connectorId: id,
          actions: pluginsStart.actions,
          request
        });
      }
    };
  }
  async stop() {
    var _this$regexWorker;
    await ((_this$regexWorker = this.regexWorker) === null || _this$regexWorker === void 0 ? void 0 : _this$regexWorker.stop());
  }
}
exports.InferencePlugin = InferencePlugin;