"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeRegexRules = executeRegexRules;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Executes multiple regex anonymization rules, detecting all matches in the original text
 * without modifying it. Returns match positions and values for later processing.
 */
async function executeRegexRules({
  records,
  rules,
  regexWorker
}) {
  return await regexWorker.run({
    rules,
    records
  });
}