"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseSerdeChunkMessage = parseSerdeChunkMessage;
exports.serializeSerdeChunkMessage = void 0;
var _utilUtf = require("@smithy/util-utf8");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Extract the completion chunk from a chunk message
 */
function parseSerdeChunkMessage(chunk) {
  return JSON.parse(Buffer.from(JSON.parse((0, _utilUtf.toUtf8)(chunk.body)).bytes, 'base64').toString('utf-8'));
}

/**
 * Reverse `parseSerdeChunkMessage`
 */
const serializeSerdeChunkMessage = input => {
  const b64 = Buffer.from(JSON.stringify(input), 'utf-8').toString('base64');
  const body = (0, _utilUtf.fromUtf8)(JSON.stringify({
    bytes: b64
  }));
  return {
    headers: {
      ':event-type': {
        type: 'string',
        value: 'chunk'
      },
      ':content-type': {
        type: 'string',
        value: 'application/json'
      },
      ':message-type': {
        type: 'string',
        value: 'event'
      }
    },
    body
  };
};
exports.serializeSerdeChunkMessage = serializeSerdeChunkMessage;