"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPrompt = createPrompt;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createPrompt(init) {
  function inner(source, ...versions) {
    const next = {
      ...source,
      versions: [...source.versions, ...versions]
    };
    return {
      version: version => inner(next, version),
      get: () => next
    };
  }
  return inner({
    ...init,
    versions: []
  });
}