"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolChoiceType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Tool invocation choice type.
 *
 * Refer to {@link ToolChoice} for more details.
 */
let ToolChoiceType = exports.ToolChoiceType = /*#__PURE__*/function (ToolChoiceType) {
  ToolChoiceType["none"] = "none";
  ToolChoiceType["auto"] = "auto";
  ToolChoiceType["required"] = "required";
  return ToolChoiceType;
}({});
/**
 * Represent a tool choice where the LLM is forced to call a specific tool.
 *
 * Refer to {@link ToolChoice} for more details.
 */
/**
 * Defines the tool invocation for {@link ToolOptions}, either a {@link ToolChoiceType} or {@link CustomToolChoice}.
 * - {@link ToolChoiceType.none}: the LLM will never call a tool
 * - {@link ToolChoiceType.auto}: the LLM will decide if it should call a tool or provide a text response
 * - {@link ToolChoiceType.required}: the LLM will always call a tool, but will decide with one to call
 * - {@link CustomToolChoice}: the LLM will always call the specified tool
 */
/**
 * The definition of a tool that will be provided to the LLM for it to eventually call.
 */
/**
 * Represents a tool call from the LLM before correctly converted to the schema type.
 *
 * Only publicly exposed because referenced by {@link ChatCompletionToolValidationError}
 */
/**
 * The shape of tool call arguments (`toolCalls[number].arguments`).
 */
/**
 * Represents a tool call performed by the LLM.
 */
/**
 * Tool-related parameters of {@link ChatCompleteAPI}
 */