"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatCompletionEventType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * List possible values of {@link ChatCompletionEvent} types.
 */
let ChatCompletionEventType = exports.ChatCompletionEventType = /*#__PURE__*/function (ChatCompletionEventType) {
  ChatCompletionEventType["ChatCompletionChunk"] = "chatCompletionChunk";
  ChatCompletionEventType["ChatCompletionTokenCount"] = "chatCompletionTokenCount";
  ChatCompletionEventType["ChatCompletionMessage"] = "chatCompletionMessage";
  return ChatCompletionEventType;
}({});
/**
 * Message event, sent only once, after all the chunks were emitted, and containing
 * the whole text content and potential tool calls of the response.
 */
/**
 * Represent a partial tool call present in a chunk event.
 *
 * Note that all properties of the structure, except from the index,
 * are partial and must be aggregated.
 */
/**
 * Chunk event, containing a fragment of the total content,
 * and potentially chunks of tool calls.
 */
/**
 * Token count structure for the chatComplete API.
 */
/**
 * Token count event, send only once, usually (but not necessarily)
 * before the message event
 */
/**
 * Events emitted from the {@link ChatCompleteResponse} observable
 * returned from the {@link ChatCompleteAPI}.
 *
 * The chatComplete API returns 3 type of events:
 * - {@link ChatCompletionChunkEvent}: message chunk events
 * - {@link ChatCompletionTokenCountEvent}: token count event
 * - {@link ChatCompletionMessageEvent}: message event
 *
 * Note that chunk events can be emitted any amount of times, but token count will be emitted
 * at most once (could not be emitted depending on the underlying connector), and message
 * event will be emitted ex
 *
 */