"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMLModelNotificationToasts = useMLModelNotificationToasts;
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _component_templates_context = require("../application/components/component_templates/component_templates_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMLModelNotificationToasts() {
  const {
    toasts
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const showSuccessToasts = modelName => {
    return toasts.addSuccess({
      title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.modelDeploymentStartedNotification', {
        defaultMessage: 'Model deployment started'
      }),
      text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.modelDeploymentNotification', {
        defaultMessage: 'Model {modelName} is being deployed on your machine learning node.',
        values: {
          modelName
        }
      })
    });
  };
  const showSuccessfullyDeployedToast = modelName => {
    return toasts.addSuccess({
      title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.modelDeploymentStartedNotification', {
        defaultMessage: 'Model deployment started'
      }),
      text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.modelDeployedNotification', {
        defaultMessage: 'Model {modelName} has been deployed on your machine learning node.',
        values: {
          modelName
        }
      })
    });
  };
  const showErrorToasts = error => {
    const errorObj = (0, _mlErrorUtils.extractErrorProperties)(error);
    return toasts.addError(new _mlErrorUtils.MLRequestFailure(errorObj, error), {
      title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.inferenceErrorTitle', {
        defaultMessage: 'Model deployment failed'
      })
    });
  };
  return {
    showSuccessToasts,
    showErrorToasts,
    showSuccessfullyDeployedToast
  };
}