"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _routing = require("../../../../../services/routing");
var _api = require("../../../../../services/api");
var _app_context = require("../../../../../app_context");
var _humanize_time_stamp = require("../../../data_stream_list/humanize_time_stamp");
var _overview_card = require("./overview_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/details_page_overview/data_stream_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DataStreamDetails = ({
  dataStreamName
}) => {
  var _dataStream$name, _dataStream$indexTemp;
  const largeFontSize = (0, _eui.useEuiFontSize)('l').fontSize;
  const {
    error,
    data: dataStream,
    isLoading,
    resendRequest
  } = (0, _api.useLoadDataStream)(dataStreamName);
  const {
    core: {
      getUrlForApp
    }
  } = (0, _app_context.useAppContext)();
  const hasError = !isLoading && (error || !dataStream);
  let contentLeft = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: (0, _react2.css)`
            font-size: ${largeFontSize};
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, dataStream === null || dataStream === void 0 ? void 0 : dataStream.generation)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.dataStream.generationLabel', {
    defaultMessage: '{generations, plural, one {Generation} other {Generations}}',
    values: {
      generations: dataStream === null || dataStream === void 0 ? void 0 : dataStream.generation
    }
  }))));
  let contentRight = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    target: "_blank",
    href: getUrlForApp('management', {
      path: `data/index_management${(0, _routing.getDataStreamDetailsLink)((_dataStream$name = dataStream === null || dataStream === void 0 ? void 0 : dataStream.name) !== null && _dataStream$name !== void 0 ? _dataStream$name : '')}`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.dataStream.dataStreamLinkLabel', {
    defaultMessage: 'See details'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    target: "_blank",
    href: getUrlForApp('management', {
      path: `data/index_management${(0, _routing.getTemplateDetailsLink)((_dataStream$indexTemp = dataStream === null || dataStream === void 0 ? void 0 : dataStream.indexTemplateName) !== null && _dataStream$indexTemp !== void 0 ? _dataStream$indexTemp : '')}`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.dataStream.templateLinkLabel', {
    defaultMessage: 'Related template'
  }))));
  if (isLoading) {
    contentLeft = /*#__PURE__*/_react.default.createElement(_public.SectionLoading, {
      inline: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.overviewTab.dataStream.loadingDescription",
      defaultMessage: "Loading data stream details\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    }));
    contentRight = null;
  }
  if (hasError) {
    contentLeft = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.overviewTab.dataStream.errorDescription",
      defaultMessage: "Unable to load data stream details",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    })));
    contentRight = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "warning",
      onClick: resendRequest,
      "data-test-subj": "indexDetailsDataStreamReload",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.overviewTab.dataStream.reloadButtonLabel",
      defaultMessage: "Reload",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_overview_card.OverviewCard, {
    "data-test-subj": "indexDetailsDataStream",
    title: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.dataStream.cardTitle', {
      defaultMessage: 'Data stream'
    }),
    content: {
      left: contentLeft,
      right: contentRight
    },
    footer: {
      left: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "calendar",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.dataStream.lastUpdateLabel', {
        defaultMessage: 'Last update'
      })), !isLoading && !hasError && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 17
        }
      }, dataStream !== null && dataStream !== void 0 && dataStream.maxTimeStamp ? (0, _humanize_time_stamp.humanizeTimeStamp)(dataStream.maxTimeStamp) : _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.dataStream.maxTimeStampNoneMessage', {
        defaultMessage: `Never`
      }))))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  });
};
exports.DataStreamDetails = DataStreamDetails;