"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteDataStreamConfirmationModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../../../../services/api");
var _notification = require("../../../../services/notification");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/data_stream_list/delete_data_stream_confirmation_modal/delete_data_stream_confirmation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteDataStreamConfirmationModal = ({
  dataStreams,
  onClose
}) => {
  const [isLoading, setLoading] = (0, _react.useState)(false);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const dataStreamsCount = dataStreams.length;
  const handleDeleteDataStreams = () => {
    setLoading(true);
    (0, _api.deleteDataStreams)(dataStreams).then(({
      data: {
        dataStreamsDeleted,
        errors
      },
      error
    }) => {
      const hasDeletedDataStreams = dataStreamsDeleted && dataStreamsDeleted.length;
      if (hasDeletedDataStreams) {
        const successMessage = dataStreamsDeleted.length === 1 ? _i18n.i18n.translate('xpack.idxMgmt.deleteDataStreamsConfirmationModal.successDeleteSingleNotificationMessageText', {
          defaultMessage: "Deleted data stream ''{dataStreamName}''",
          values: {
            dataStreamName: dataStreams[0]
          }
        }) : _i18n.i18n.translate('xpack.idxMgmt.deleteDataStreamsConfirmationModal.successDeleteMultipleNotificationMessageText', {
          defaultMessage: 'Deleted {numSuccesses, plural, one {# data stream} other {# data streams}}',
          values: {
            numSuccesses: dataStreamsDeleted.length
          }
        });
        onClose({
          hasDeletedDataStreams
        });
        _notification.notificationService.showSuccessToast(successMessage);
      }
      if (error || errors && errors.length) {
        const hasMultipleErrors = errors && errors.length > 1 || error && dataStreams.length > 1;
        const errorMessage = hasMultipleErrors ? _i18n.i18n.translate('xpack.idxMgmt.deleteDataStreamsConfirmationModal.multipleErrorsNotificationMessageText', {
          defaultMessage: 'Error deleting {count} data streams',
          values: {
            count: errors && errors.length || dataStreams.length
          }
        }) : _i18n.i18n.translate('xpack.idxMgmt.deleteDataStreamsConfirmationModal.errorNotificationMessageText', {
          defaultMessage: "Error deleting data stream ''{name}''",
          values: {
            name: errors && errors[0].name || dataStreams[0]
          }
        });
        _notification.notificationService.showDangerToast(errorMessage);
      }
    }).finally(() => setLoading(false));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    buttonColor: "danger",
    "data-test-subj": "deleteDataStreamsConfirmation",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteDataStreamsConfirmationModal.modalTitleText",
      defaultMessage: "Delete {dataStreamsCount, plural, one {data stream} other {# data streams}}",
      values: {
        dataStreamsCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }),
    onCancel: () => onClose(),
    onConfirm: handleDeleteDataStreams,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteDataStreamsConfirmationModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteDataStreamsConfirmationModal.confirmButtonLabel",
      defaultMessage: "Delete {dataStreamsCount, plural, one {data stream} other {data streams} }",
      values: {
        dataStreamsCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }),
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteDataStreamsConfirmationModal.warningTitle",
      defaultMessage: "Deleting data streams also deletes indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 13
      }
    }),
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.deleteDataStreamsConfirmationModal.warningMessage",
    defaultMessage: "Data streams are collections of time series indices. Deleting a data stream will also delete its indices.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.deleteDataStreamsConfirmationModal.deleteDescription",
    defaultMessage: "You are about to delete {dataStreamsCount, plural, one {this data stream} other {these data streams} }:",
    values: {
      dataStreamsCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, dataStreams.map(name => /*#__PURE__*/_react.default.createElement("li", {
    key: name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  }, name)))));
};
exports.DeleteDataStreamConfirmationModal = DeleteDataStreamConfirmationModal;