"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStateWithLocalStorage = useStateWithLocalStorage;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function parseJsonOrDefault(value, defaultValue) {
  if (!value) {
    return defaultValue;
  }
  try {
    return JSON.parse(value);
  } catch (e) {
    return defaultValue;
  }
}
function useStateWithLocalStorage(key, defaultState) {
  const storageState = localStorage.getItem(key);
  const [state, setState] = (0, _react.useState)(parseJsonOrDefault(storageState, defaultState));
  (0, _react.useEffect)(() => {
    localStorage.setItem(key, JSON.stringify(state));
  }, [key, state]);
  return [state, setState];
}