"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplateForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../shared_imports");
var _lib = require("../../../../../../common/lib");
var _component_templates_context = require("../../component_templates_context");
var _steps = require("./steps");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_wizard/component_template_form/component_template_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  stripEmptyFields
} = _shared_imports.serializers;
const {
  FormWizard,
  FormWizardStep
} = _shared_imports.Forms;
const wizardSections = {
  logistics: {
    id: 'logistics',
    label: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.steps.logisticsStepName', {
      defaultMessage: 'Logistics'
    })
  },
  settings: {
    id: 'settings',
    label: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.steps.settingsStepName', {
      defaultMessage: 'Index settings'
    })
  },
  mappings: {
    id: 'mappings',
    label: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.steps.mappingsStepName', {
      defaultMessage: 'Mappings'
    })
  },
  aliases: {
    id: 'aliases',
    label: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.steps.aliasesStepName', {
      defaultMessage: 'Aliases'
    })
  },
  review: {
    id: 'review',
    label: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.steps.summaryStepName', {
      defaultMessage: 'Review'
    })
  }
};
const ComponentTemplateForm = ({
  defaultValue = {
    name: '',
    template: {},
    _meta: {},
    _kbnMeta: {
      usedBy: [],
      isManaged: false
    }
  },
  setComponentName,
  dataStreams,
  canRollover,
  isEditing,
  isSaving,
  saveError,
  clearSaveError,
  defaultActiveWizardSection,
  onSave,
  onStepChange
}) => {
  const {
    template: {
      settings,
      mappings,
      aliases,
      lifecycle,
      data_stream_options: dataStreamOptions
    },
    ...logistics
  } = defaultValue;
  const {
    documentation
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const wizardDefaultValue = {
    logistics: {
      ...logistics,
      ...(lifecycle ? {
        lifecycle: (0, _lib.deserializeESLifecycle)(lifecycle)
      } : {})
    },
    settings,
    mappings,
    aliases
  };
  const i18nTexts = {
    save: isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.saveButtonLabel",
      defaultMessage: "Save component template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.createButtonLabel",
      defaultMessage: "Create component template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 7
      }
    })
  };
  const apiError = saveError ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.saveTemplateError",
      defaultMessage: "Unable to create component template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 11
      }
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "saveComponentTemplateError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, saveError.message || saveError.statusText)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  })) : null;

  /**
   * If no mappings, settings or aliases are defined, it is better to not send an empty
   * object for those values.
   * @param componentTemplate The component template object to clean up
   */
  const cleanupComponentTemplateObject = componentTemplate => {
    const outputTemplate = {
      ...componentTemplate
    };
    if (outputTemplate.template.settings === undefined) {
      delete outputTemplate.template.settings;
    }
    if (outputTemplate.template.mappings === undefined) {
      delete outputTemplate.template.mappings;
    }
    if (outputTemplate.template.aliases === undefined) {
      delete outputTemplate.template.aliases;
    }
    if (outputTemplate.lifecycle) {
      delete outputTemplate.lifecycle;
    }
    return outputTemplate;
  };
  const buildComponentTemplateObject = (0, _react.useCallback)(initialTemplate => wizardData => {
    const outputComponentTemplate = {
      ...initialTemplate,
      name: wizardData.logistics.name,
      version: wizardData.logistics.version,
      _meta: wizardData.logistics._meta,
      template: {
        settings: wizardData.settings,
        mappings: wizardData.mappings,
        aliases: wizardData.aliases,
        lifecycle: wizardData.logistics.lifecycle ? (0, _lib.serializeAsESLifecycle)(wizardData.logistics.lifecycle) : undefined
      }
    };
    return cleanupComponentTemplateObject(outputComponentTemplate);
  }, []);
  const onSaveComponentTemplate = (0, _react.useCallback)(async wizardData => {
    const componentTemplate = buildComponentTemplateObject(defaultValue)(wizardData);

    // This will strip an empty string if "version" is not set, as well as an empty "_meta" object
    onSave(stripEmptyFields(componentTemplate, {
      types: ['string']
    }));
    clearSaveError();
  }, [buildComponentTemplateObject, defaultValue, onSave, clearSaveError]);
  const defaultActiveStepIndex = (0, _react.useMemo)(() => Math.max(defaultActiveWizardSection ? Object.keys(wizardSections).indexOf(defaultActiveWizardSection) : 0, 0), [defaultActiveWizardSection]);
  return /*#__PURE__*/_react.default.createElement(FormWizard, {
    defaultValue: wizardDefaultValue,
    onSave: onSaveComponentTemplate,
    isEditing: isEditing,
    isSaving: isSaving,
    apiError: apiError,
    texts: i18nTexts,
    defaultActiveStep: defaultActiveStepIndex,
    onStepChange: onStepChange,
    onChange: attrs => {
      // Let the parent component know the name of the component template in the
      // form has changed, so that it can re-compute the canRollover prop.
      // This is needed for determinating if the user should see a rollover
      // attached datastreams modal or not.
      const data = attrs.getData();
      if (setComponentName) {
        setComponentName(data.logistics.name);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FormWizardStep, {
    id: wizardSections.logistics.id,
    label: wizardSections.logistics.label,
    isRequired: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_steps.StepLogisticsContainer, {
    isEditing: isEditing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(FormWizardStep, {
    id: wizardSections.settings.id,
    label: wizardSections.settings.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.StepSettingsContainer, {
    esDocsBase: documentation.esDocsBase,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(FormWizardStep, {
    id: wizardSections.mappings.id,
    label: wizardSections.mappings.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.StepMappingsContainer, {
    esDocsBase: documentation.esDocsBase,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(FormWizardStep, {
    id: wizardSections.aliases.id,
    label: wizardSections.aliases.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.StepAliasesContainer, {
    esDocsBase: documentation.esDocsBase,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(FormWizardStep, {
    id: wizardSections.review.id,
    label: wizardSections.review.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_steps.StepReviewContainer, {
    getComponentTemplateData: buildComponentTemplateObject(defaultValue),
    dataStreams: dataStreams,
    canRollover: canRollover,
    dataStreamOptions: dataStreamOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 9
    }
  })));
};
exports.ComponentTemplateForm = ComponentTemplateForm;