"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormErrorsContext = exports.FormErrorsProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/form/form_errors_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FormErrorsContext = /*#__PURE__*/(0, _react.createContext)(null);
const createEmptyErrors = () => ({
  hasErrors: false,
  hot: {},
  warm: {},
  cold: {},
  frozen: {},
  delete: {},
  other: {}
});
const FormErrorsProvider = ({
  children
}) => {
  const [errors, setErrors] = (0, _react.useState)(createEmptyErrors);
  const form = (0, _shared_imports.useFormContext)();
  const {
    getErrors: getFormErrors,
    isSubmitted
  } = form;
  const addError = (0, _react.useCallback)((phase, fieldPath, errorMessages) => {
    setErrors(previousErrors => ({
      ...previousErrors,
      hasErrors: true,
      [phase]: {
        ...previousErrors[phase],
        [fieldPath]: errorMessages
      }
    }));
  }, [setErrors]);
  const clearError = (0, _react.useCallback)((phase, fieldPath) => {
    if (getFormErrors().length) {
      setErrors(previousErrors => {
        const {
          [phase]: {
            [fieldPath]: fieldErrorToOmit,
            ...restOfPhaseErrors
          },
          hasErrors,
          ...otherPhases
        } = previousErrors;
        const nextHasErrors = Object.keys(restOfPhaseErrors).length > 0 || Object.values(otherPhases).some(phaseErrors => {
          // @ts-expect-error upgrade typescript v4.9.5
          return Object.keys(phaseErrors).length > 0;
        });
        return {
          ...previousErrors,
          hasErrors: nextHasErrors,
          [phase]: restOfPhaseErrors
        };
      });
    } else {
      setErrors(createEmptyErrors);
    }
  }, [getFormErrors, setErrors]);
  return /*#__PURE__*/_react.default.createElement(FormErrorsContext.Provider, {
    value: {
      errors,
      addError,
      clearError,
      isFormSubmitted: isSubmitted
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }, children);
};
exports.FormErrorsProvider = FormErrorsProvider;
const useFormErrorsContext = () => {
  const ctx = (0, _react.useContext)(FormErrorsContext);
  if (!ctx) {
    throw new Error('useFormErrorsContext can only be used inside of FormErrorsProvider');
  }
  return ctx;
};
exports.useFormErrorsContext = useFormErrorsContext;