"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimingLabelForPhase = getTimingLabelForPhase;
exports.getUnitsAriaLabelForPhase = getUnitsAriaLabelForPhase;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getUnitsAriaLabelForPhase(phase) {
  switch (phase) {
    case 'warm':
      return _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.phaseWarm.minimumAgeUnitsAriaLabel', {
        defaultMessage: 'Units for timing of warm phase'
      });
    case 'cold':
      return _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.phaseCold.minimumAgeUnitsAriaLabel', {
        defaultMessage: 'Units for timing of cold phase'
      });
    case 'frozen':
      return _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.phaseFrozen.minimumAgeUnitsAriaLabel', {
        defaultMessage: 'Units for timing of frozen phase'
      });
    case 'delete':
      return _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.phaseDelete.minimumAgeUnitsAriaLabel', {
        defaultMessage: 'Units for timing of delete phase'
      });
  }
}
function getTimingLabelForPhase(phase) {
  switch (phase) {
    case 'warm':
      return _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.phaseWarm.minimumAgeLabel', {
        defaultMessage: 'Timing for warm phase'
      });
    case 'cold':
      return _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.phaseCold.minimumAgeLabel', {
        defaultMessage: 'Timing for cold phase'
      });
    case 'frozen':
      return _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.phaseFrozen.minimumAgeLabel', {
        defaultMessage: 'Timing for frozen phase'
      });
    case 'delete':
      return _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.phaseDelete.minimumAgeLabel', {
        defaultMessage: 'Timing for delete phase'
      });
  }
}