"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudDataTierCallout = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/data_tier_allocation_field/components/cloud_data_tier_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.cloudDataTierCallout.title', {
    defaultMessage: 'Migrate to data tiers'
  }),
  body: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.cloudDataTierCallout.body', {
    defaultMessage: 'Migrate your Elastic Cloud deployment to use data tiers.'
  }),
  linkText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.cloudDataTierCallout.linkToCloudDeploymentDescription', {
    defaultMessage: 'View cloud deployment'
  })
};
/**
 * A call-to-action for users to migrate to data tiers if their cluster is still running
 * the deprecated node.data:true config.
 */
const CloudDataTierCallout = ({
  linkToCloudDeployment
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.title,
    "data-test-subj": "cloudDataTierCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, i18nTexts.body, ' ', Boolean(linkToCloudDeployment) && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: linkToCloudDeployment,
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, i18nTexts.linkText));
};
exports.CloudDataTierCallout = CloudDataTierCallout;