"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asKQL = asKQL;
var _rison = _interopRequireDefault(require("@kbn/rison"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function escapeQuotes(str) {
  return str.replace(/\\/g, '\\\\').replace(/"/g, '\\"');
}
function asKQL(workspace, joinBy) {
  const nodes = workspace.returnUnpackedGroupeds(workspace.getSelectedOrAllNodes());
  const clauses = nodes.map(node => `"${escapeQuotes(node.data.field)}" : "${escapeQuotes(node.data.term)}"`);
  const expression = clauses.join(` ${joinBy} `);
  return encodeURIComponent(_rison.default.encode(expression));
}