"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalSearchPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _license_checker = require("../common/license_checker");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class GlobalSearchPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "licenseChecker", void 0);
    (0, _defineProperty2.default)(this, "searchService", new _services.SearchService());
    this.config = context.config.get();
  }
  setup(core) {
    const {
      registerResultProvider
    } = this.searchService.setup({
      config: this.config
    });
    return {
      registerResultProvider
    };
  }
  start({
    http
  }, {
    licensing
  }) {
    this.licenseChecker = new _license_checker.LicenseChecker(licensing.license$);
    const {
      find,
      getSearchableTypes
    } = this.searchService.start({
      http,
      licenseChecker: this.licenseChecker
    });
    return {
      find,
      getSearchableTypes
    };
  }
  stop() {
    if (this.licenseChecker) {
      this.licenseChecker.clean();
    }
  }
}
exports.GlobalSearchPlugin = GlobalSearchPlugin;