"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateNoPathTraversal = validateNoPathTraversal;
var _repoInfo = require("@kbn/repo-info");
var _path = require("path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_PATH = (0, _path.join)(_repoInfo.REPO_ROOT, 'data');
const DATA_PATH_RESOLVED = (0, _path.resolve)(DATA_PATH);
function validateNoPathTraversal(fullPath) {
  const resolvedPath = (0, _path.resolve)(fullPath);
  if (!resolvedPath.startsWith(DATA_PATH_RESOLVED)) {
    throw new Error(`Path traversal detected: ${fullPath}`);
  }
  return resolvedPath;
}