"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateFileExtension = validateFileExtension;
var _path = _interopRequireDefault(require("path"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allowedExtensions = ['.txt', '.md', '.log', '.json', '.yml', '.yaml', '.csv', '.svg', '.png'];
function validateFileExtension(filePath) {
  const extension = _path.default.extname(filePath).toLowerCase();
  const hasAllowedExtension = allowedExtensions.includes(extension);
  if (!hasAllowedExtension) {
    throw new Error(`Invalid file type: "${filePath}". Only ${allowedExtensions.join(', ')} files are allowed.`);
  }
}