"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PutFleetServerHostRequestSchema = exports.PostFleetServerHostRequestSchema = exports.GetOneFleetServerHostRequestSchema = exports.GetAllFleetServerHostRequestSchema = exports.FleetServerHostSchema = exports.FleetServerHostResponseSchema = exports.FleetServerHostBaseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _types = require("../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const secretRefSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  id: _configSchema.schema.string()
}), _configSchema.schema.string()]);
const FleetServerHostBaseSchema = exports.FleetServerHostBaseSchema = _configSchema.schema.object({
  name: _configSchema.schema.maybe(_configSchema.schema.string()),
  host_urls: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1
  })),
  is_default: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: false
  })),
  is_internal: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  proxy_id: _configSchema.schema.nullable(_configSchema.schema.string()),
  secrets: _configSchema.schema.maybe(_configSchema.schema.object({
    ssl: _configSchema.schema.maybe(_configSchema.schema.object({
      key: _configSchema.schema.maybe(secretRefSchema),
      es_key: _configSchema.schema.maybe(secretRefSchema)
    }))
  })),
  ssl: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.object({
    certificate_authorities: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    certificate: _configSchema.schema.maybe(_configSchema.schema.string()),
    key: _configSchema.schema.maybe(_configSchema.schema.string()),
    es_certificate_authorities: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    es_certificate: _configSchema.schema.maybe(_configSchema.schema.string()),
    es_key: _configSchema.schema.maybe(_configSchema.schema.string()),
    client_auth: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_types.clientAuth.Optional), _configSchema.schema.literal(_types.clientAuth.Required), _configSchema.schema.literal(_types.clientAuth.None)]))
  })]))
});
const FleetServerHostSchema = exports.FleetServerHostSchema = FleetServerHostBaseSchema.extends({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  host_urls: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1
  }),
  is_default: _configSchema.schema.boolean({
    defaultValue: false
  }),
  is_internal: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  is_preconfigured: _configSchema.schema.boolean({
    defaultValue: false
  }),
  proxy_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()]))
});
const FleetServerHostResponseSchema = exports.FleetServerHostResponseSchema = _configSchema.schema.object({
  item: FleetServerHostSchema
});
const PostFleetServerHostRequestSchema = exports.PostFleetServerHostRequestSchema = {
  body: FleetServerHostSchema.extends({
    id: _configSchema.schema.maybe(_configSchema.schema.string())
  })
};
const GetOneFleetServerHostRequestSchema = exports.GetOneFleetServerHostRequestSchema = {
  params: _configSchema.schema.object({
    itemId: _configSchema.schema.string()
  })
};
const PutFleetServerHostRequestSchema = exports.PutFleetServerHostRequestSchema = {
  params: _configSchema.schema.object({
    itemId: _configSchema.schema.string()
  }),
  body: FleetServerHostBaseSchema
};
const GetAllFleetServerHostRequestSchema = exports.GetAllFleetServerHostRequestSchema = {};