"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateAgentPolicyRequestSchema = exports.GetOneAgentPolicyRequestSchema = exports.GetListAgentPolicyOutputsRequestSchema = exports.GetK8sManifestResponseScheme = exports.GetK8sManifestRequestSchema = exports.GetFullAgentPolicyResponseSchema = exports.GetFullAgentPolicyRequestSchema = exports.GetAutoUpgradeAgentsStatusRequestSchema = exports.GetAgentPolicyOutputsRequestSchema = exports.GetAgentPoliciesRequestSchema = exports.DownloadFullAgentPolicyResponseSchema = exports.DeleteAgentPolicyResponseSchema = exports.DeleteAgentPolicyRequestSchema = exports.CreateAgentPolicyRequestSchema = exports.CreateAgentAndPackagePolicyRequestSchema = exports.CopyAgentPolicyRequestSchema = exports.BulkGetAgentPoliciesResponseSchema = exports.BulkGetAgentPoliciesRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _models = require("../models");
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _filter_utils = require("../../routes/utils/filter_utils");
var _common = require("./common");
var _package_policy = require("./package_policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetAgentPoliciesRequestSchema = exports.GetAgentPoliciesRequestSchema = {
  query: _configSchema.schema.object({
    page: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 1
    })),
    perPage: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 20
    })),
    sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
    sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('desc'), _configSchema.schema.literal('asc')])),
    showUpgradeable: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    kuery: _configSchema.schema.maybe(_configSchema.schema.string({
      validate: value => {
        const validationObj = (0, _filter_utils.validateKuery)(value, [_constants2.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE], _constants2.AGENT_POLICY_MAPPINGS, true);
        if (validationObj !== null && validationObj !== void 0 && validationObj.error) {
          return validationObj === null || validationObj === void 0 ? void 0 : validationObj.error;
        }
      }
    })),
    noAgentCount: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'use withAgentCount instead',
        deprecated: true
      }
    })),
    withAgentCount: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'get policies with agent count'
      }
    })),
    full: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'get full policies with package policies populated'
      }
    })),
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)]))
  }, {
    validate: query => {
      if (query.perPage && query.perPage > 100 && (query.full || query.noAgentCount === false || query.withAgentCount === true)) {
        return 'perPage should be less or equal to 100 when fetching full policies or agent count.';
      }
    }
  })
};
const BulkGetAgentPoliciesRequestSchema = exports.BulkGetAgentPoliciesRequestSchema = {
  body: _common.BulkRequestBodySchema.extends({
    full: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'get full policies with package policies populated'
      }
    }))
  }),
  query: _configSchema.schema.object({
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)]))
  })
};
const BulkGetAgentPoliciesResponseSchema = exports.BulkGetAgentPoliciesResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_models.AgentPolicyResponseSchema)
});
const GetOneAgentPolicyRequestSchema = exports.GetOneAgentPolicyRequestSchema = {
  params: _configSchema.schema.object({
    agentPolicyId: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    format: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.inputsFormat.Simplified), _configSchema.schema.literal(_constants.inputsFormat.Legacy)]))
  })
};
const GetAutoUpgradeAgentsStatusRequestSchema = exports.GetAutoUpgradeAgentsStatusRequestSchema = {
  params: _configSchema.schema.object({
    agentPolicyId: _configSchema.schema.string()
  })
};
const CreateAgentPolicyRequestSchema = exports.CreateAgentPolicyRequestSchema = {
  body: _models.NewAgentPolicySchema,
  query: _configSchema.schema.object({
    sys_monitoring: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const CreateAgentAndPackagePolicyRequestSchema = exports.CreateAgentAndPackagePolicyRequestSchema = {
  body: CreateAgentPolicyRequestSchema.body.extends({
    package_policies: _configSchema.schema.arrayOf(_package_policy.CreatePackagePolicyRequestSchema.body)
  }),
  query: _configSchema.schema.intersection([CreateAgentPolicyRequestSchema.query, _package_policy.CreatePackagePolicyRequestSchema.query])
};
const UpdateAgentPolicyRequestSchema = exports.UpdateAgentPolicyRequestSchema = {
  ...GetOneAgentPolicyRequestSchema,
  body: _models.NewAgentPolicySchema.extends({
    force: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    bumpRevision: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const CopyAgentPolicyRequestSchema = exports.CopyAgentPolicyRequestSchema = {
  ...GetOneAgentPolicyRequestSchema,
  body: _configSchema.schema.object({
    name: _configSchema.schema.string({
      minLength: 1
    }),
    description: _configSchema.schema.maybe(_configSchema.schema.string())
  })
};
const DeleteAgentPolicyRequestSchema = exports.DeleteAgentPolicyRequestSchema = {
  body: _configSchema.schema.object({
    agentPolicyId: _configSchema.schema.string(),
    force: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'bypass validation checks that can prevent agent policy deletion'
      }
    }))
  })
};
const DeleteAgentPolicyResponseSchema = exports.DeleteAgentPolicyResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string()
});
const GetFullAgentPolicyRequestSchema = exports.GetFullAgentPolicyRequestSchema = {
  params: _configSchema.schema.object({
    agentPolicyId: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    download: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    standalone: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    kubernetes: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const GetFullAgentPolicyResponseSchema = exports.GetFullAgentPolicyResponseSchema = _configSchema.schema.object({
  item: _configSchema.schema.oneOf([_configSchema.schema.string(), _models.FullAgentPolicyResponseSchema])
});
const DownloadFullAgentPolicyResponseSchema = exports.DownloadFullAgentPolicyResponseSchema = _configSchema.schema.string();
const GetK8sManifestRequestSchema = exports.GetK8sManifestRequestSchema = {
  query: _configSchema.schema.object({
    download: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    fleetServer: _configSchema.schema.maybe(_configSchema.schema.string()),
    enrolToken: _configSchema.schema.maybe(_configSchema.schema.string())
  })
};
const GetK8sManifestResponseScheme = exports.GetK8sManifestResponseScheme = _configSchema.schema.object({
  item: _configSchema.schema.string()
});
const GetAgentPolicyOutputsRequestSchema = exports.GetAgentPolicyOutputsRequestSchema = {
  params: _configSchema.schema.object({
    agentPolicyId: _configSchema.schema.string()
  })
};
const GetListAgentPolicyOutputsRequestSchema = exports.GetListAgentPolicyOutputsRequestSchema = {
  body: _configSchema.schema.object({
    ids: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      meta: {
        description: 'list of package policy ids'
      }
    })
  })
};