"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteDownloadSourceSecrets = deleteDownloadSourceSecrets;
exports.extractAndUpdateDownloadSourceSecrets = extractAndUpdateDownloadSourceSecrets;
exports.extractAndWriteDownloadSourcesSecrets = extractAndWriteDownloadSourcesSecrets;
exports.getDownloadSourceSecretReferences = getDownloadSourceSecretReferences;
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function extractAndWriteDownloadSourcesSecrets(opts) {
  const {
    downloadSource,
    esClient,
    secretHashes = {}
  } = opts;
  const secretPaths = getDownloadSourcesSecretPaths(downloadSource).filter(path => typeof path.value === 'string');
  const secretRes = await (0, _common.extractAndWriteSOSecrets)({
    soObject: downloadSource,
    secretPaths,
    esClient,
    secretHashes
  });
  return {
    downloadSource: secretRes.soObjectWithSecrets,
    secretReferences: secretRes.secretReferences
  };
}
async function extractAndUpdateDownloadSourceSecrets(opts) {
  const {
    oldDownloadSource,
    downloadSourceUpdate,
    esClient,
    secretHashes
  } = opts;
  const oldSecretPaths = getDownloadSourcesSecretPaths(oldDownloadSource);
  const updatedSecretPaths = getDownloadSourcesSecretPaths(downloadSourceUpdate);
  const secretsRes = await (0, _common.extractAndUpdateSOSecrets)({
    updatedSoObject: downloadSourceUpdate,
    oldSecretPaths,
    updatedSecretPaths,
    esClient,
    secretHashes
  });
  return {
    downloadSourceUpdate: secretsRes.updatedSoObject,
    secretReferences: secretsRes.secretReferences,
    secretsToDelete: secretsRes.secretsToDelete
  };
}
async function deleteDownloadSourceSecrets(opts) {
  const {
    downloadSource,
    esClient
  } = opts;
  const secretPaths = getDownloadSourcesSecretPaths(downloadSource);
  await (0, _common.deleteSOSecrets)(esClient, secretPaths);
}
function getDownloadSourceSecretReferences(downloadSource) {
  var _downloadSource$secre, _downloadSource$secre2;
  const secretPaths = [];
  if (typeof ((_downloadSource$secre = downloadSource.secrets) === null || _downloadSource$secre === void 0 ? void 0 : (_downloadSource$secre2 = _downloadSource$secre.ssl) === null || _downloadSource$secre2 === void 0 ? void 0 : _downloadSource$secre2.key) === 'object') {
    secretPaths.push({
      id: downloadSource.secrets.ssl.key.id
    });
  }
  return secretPaths;
}
function getDownloadSourcesSecretPaths(downloadSource) {
  var _downloadSource$secre3, _downloadSource$secre4;
  const secretPaths = [];
  if (downloadSource !== null && downloadSource !== void 0 && (_downloadSource$secre3 = downloadSource.secrets) !== null && _downloadSource$secre3 !== void 0 && (_downloadSource$secre4 = _downloadSource$secre3.ssl) !== null && _downloadSource$secre4 !== void 0 && _downloadSource$secre4.key) {
    secretPaths.push({
      path: 'secrets.ssl.key',
      value: downloadSource.secrets.ssl.key
    });
  }
  return secretPaths;
}