"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanUpMlModelStep = cleanUpMlModelStep;
exports.stepInstallMlModel = stepInstallMlModel;
var _types = require("../../../../../../common/types");
var _ml_model = require("../../../elasticsearch/ml_model");
var _remove = require("../../remove");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepInstallMlModel(context) {
  var _context$esReferences;
  const {
    logger,
    packageInstallContext,
    esClient,
    savedObjectsClient
  } = context;
  let esReferences = (_context$esReferences = context.esReferences) !== null && _context$esReferences !== void 0 ? _context$esReferences : [];
  esReferences = await (0, _utils.withPackageSpan)('Install ML models', () => (0, _ml_model.installMlModel)(packageInstallContext, esClient, savedObjectsClient, logger, esReferences));
  return {
    esReferences
  };
}
async function cleanUpMlModelStep(context) {
  var _installedPkg$attribu;
  const {
    logger,
    esClient,
    installedPkg,
    retryFromLastState,
    force,
    initialState
  } = context;

  // In case of retry clean up previous installed assets
  if (!force && retryFromLastState && initialState === _types.INSTALL_STATES.INSTALL_ML_MODEL && installedPkg !== null && installedPkg !== void 0 && (_installedPkg$attribu = installedPkg.attributes) !== null && _installedPkg$attribu !== void 0 && _installedPkg$attribu.installed_es && installedPkg.attributes.installed_es.length > 0) {
    const {
      installed_es: installedEs
    } = installedPkg.attributes;
    const {
      indexTemplatesAndPipelines,
      indexAssets,
      transformAssets
    } = (0, _remove.splitESAssets)(installedEs);
    logger.debug('Retry transition - clean up prerequisite ES assets first');
    await (0, _utils.withPackageSpan)('Retry transition - clean up prerequisite ES assets first', async () => {
      await (0, _remove.deletePrerequisiteAssets)({
        indexAssets,
        transformAssets,
        indexTemplatesAndPipelines
      }, esClient);
    });
    logger.debug('Retry transition - clean up ML model');
    await (0, _utils.withPackageSpan)('Retry transition - clean up ML model', async () => {
      await (0, _remove.deleteMLModels)(installedEs, esClient);
    });
  }
}