"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migratePackagePolicyToV8100 = exports.migratePackagePolicyEvictionsFromV8100 = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migratePackagePolicyToV8100 = packagePolicyDoc => {
  var _packagePolicyDoc$att;
  if (((_packagePolicyDoc$att = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att === void 0 ? void 0 : _packagePolicyDoc$att.name) !== 'endpoint') {
    return {
      attributes: packagePolicyDoc.attributes
    };
  }
  const updatedPackagePolicyDoc = packagePolicyDoc;
  const input = updatedPackagePolicyDoc.attributes.inputs[0];
  if (input && input.config) {
    const policy = input.config.policy.value;
    const newMetaValues = {
      license_uid: '',
      cluster_uuid: '',
      cluster_name: ''
    };
    policy.meta = policy !== null && policy !== void 0 && policy.meta ? {
      ...policy.meta,
      ...newMetaValues
    } : newMetaValues;
    policy.windows.behavior_protection.reputation_service = false;
    policy.mac.behavior_protection.reputation_service = false;
    policy.linux.behavior_protection.reputation_service = false;
  }
  return {
    attributes: {
      inputs: updatedPackagePolicyDoc.attributes.inputs
    }
  };
};
exports.migratePackagePolicyToV8100 = migratePackagePolicyToV8100;
const migratePackagePolicyEvictionsFromV8100 = unknownAttributes => {
  var _attributes$package;
  const attributes = unknownAttributes;
  if (((_attributes$package = attributes.package) === null || _attributes$package === void 0 ? void 0 : _attributes$package.name) !== 'endpoint') {
    return attributes;
  }
  const updatedAttributes = attributes;
  const input = updatedAttributes.inputs[0];
  if (input && input.config) {
    const policy = input.config.policy.value;
    policy.windows.behavior_protection = (0, _lodash.omit)(policy.windows.behavior_protection, ['reputation_service']);
    policy.linux.behavior_protection = (0, _lodash.omit)(policy.linux.behavior_protection, ['reputation_service']);
    policy.mac.behavior_protection = (0, _lodash.omit)(policy.mac.behavior_protection, ['reputation_service']);
    policy.meta = (0, _lodash.omit)(policy.meta, ['license_uid', 'cluster_uuid', 'cluster_name']);
  }
  return updatedAttributes;
};
exports.migratePackagePolicyEvictionsFromV8100 = migratePackagePolicyEvictionsFromV8100;