"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _api_privileges = require("../../constants/api_privileges");
var _types = require("../../types");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  router.versioned.post({
    path: _constants2.CREATE_STANDALONE_AGENT_API_KEY_ROUTE,
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.internal.v1,
    validate: {
      request: _types.PostStandaloneAgentAPIKeyRequestSchema
    }
  }, _handler.createStandaloneAgentApiKeyHandler);
};
exports.registerRoutes = registerRoutes;