"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _types = require("../../types");
var _errors = require("../schema/errors");
var _api_privileges = require("../../constants/api_privileges");
var _utils = require("../schema/utils");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  router.versioned.get({
    path: _constants2.DOWNLOAD_SOURCE_API_ROUTES.LIST_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [{
          anyRequired: [_api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.READ, _api_privileges.FLEET_API_PRIVILEGES.SETTINGS.READ]
        }]
      }
    },
    summary: `Get agent binary download sources`,
    options: {
      tags: ['oas-tag:Elastic Agent binary download sources']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.getDownloadSourcesRequestSchema,
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => (0, _utils.ListResponseSchema)(_types.DownloadSourceResponseSchema)
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handler.getDownloadSourcesHandler);
  router.versioned.get({
    path: _constants2.DOWNLOAD_SOURCE_API_ROUTES.INFO_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [{
          anyRequired: [_api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.READ, _api_privileges.FLEET_API_PRIVILEGES.SETTINGS.READ]
        }]
      }
    },
    summary: `Get an agent binary download source`,
    description: `Get an agent binary download source by ID.`,
    options: {
      tags: ['oas-tag:Elastic Agent binary download sources']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOneDownloadSourcesRequestSchema,
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => _types.GetDownloadSourceResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handler.getOneDownloadSourcesHandler);
  router.versioned.put({
    path: _constants2.DOWNLOAD_SOURCE_API_ROUTES.UPDATE_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
      }
    },
    summary: `Update an agent binary download source`,
    description: `Update an agent binary download source by ID.`,
    options: {
      tags: ['oas-tag:Elastic Agent binary download sources']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PutDownloadSourcesRequestSchema,
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => _types.GetDownloadSourceResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handler.putDownloadSourcesHandler);
  router.versioned.post({
    path: _constants2.DOWNLOAD_SOURCE_API_ROUTES.CREATE_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
      }
    },
    summary: `Create an agent binary download source`,
    options: {
      tags: ['oas-tag:Elastic Agent binary download sources']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostDownloadSourcesRequestSchema,
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => _types.GetDownloadSourceResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handler.postDownloadSourcesHandler);
  router.versioned.delete({
    path: _constants2.DOWNLOAD_SOURCE_API_ROUTES.DELETE_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
      }
    },
    summary: `Delete an agent binary download source`,
    description: `Delete an agent binary download source by ID.`,
    options: {
      tags: ['oas-tag:Elastic Agent binary download sources']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.DeleteDownloadSourcesRequestSchema,
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => _types.DeleteDownloadSourcesResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handler.deleteDownloadSourcesHandler);
};
exports.registerRoutes = registerRoutes;