"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.incrementPolicyName = incrementPolicyName;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function incrementPolicyName(policies, isFleetServerPolicy) {
  const indices = policies.map(pol => pol.name).map(name => {
    const match = name.match(isFleetServerPolicy ? /Fleet Server policy (\d+)/ : /Agent policy (\d+)/);
    return match ? parseInt(match[1], 10) : 0;
  });
  return `${isFleetServerPolicy ? 'Fleet Server' : 'Agent'} policy ${Math.max(...indices, 0) + 1}`;
}