"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionsError = exports.ErrorLayout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _hooks = require("../hooks");
var _agent_requirements_page = require("../applications/fleet/sections/agents/agent_requirements_page");
var _ = require(".");
var _components = require("../applications/fleet/components");
var _default = require("../applications/fleet/layouts/default");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/layouts/error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Panel = (0, _styled.default)(_eui.EuiPanel)`
  max-width: 500px;
  margin-right: auto;
  margin-left: auto;
`;
const ErrorLayout = ({
  isAddIntegrationsPath,
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 33,
    columnNumber: 3
  }
}, isAddIntegrationsPath ? /*#__PURE__*/_react.default.createElement(_.WithHeaderLayout, {
  leftColumn: /*#__PURE__*/_react.default.createElement(_default.DefaultPageTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 37
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 7
  }
}, children) : /*#__PURE__*/_react.default.createElement(_default.DefaultLayout, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_.WithoutHeaderLayout, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 9
  }
}, children)));
exports.ErrorLayout = ErrorLayout;
const PermissionsError = exports.PermissionsError = /*#__PURE__*/_react.default.memo(({
  error,
  requiredFleetRole,
  callingApplication
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  if (error === 'MISSING_SECURITY') {
    return /*#__PURE__*/_react.default.createElement(_agent_requirements_page.MissingESRequirementsPage, {
      missingRequirements: ['security_required', 'api_keys'],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 12
      }
    });
  }
  if (error === 'MISSING_PRIVILEGES') {
    return /*#__PURE__*/_react.default.createElement(Panel, {
      "data-test-subj": "missingPrivilegesPrompt",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "securityApp",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        "data-test-subj": "missingPrivilegesPromptTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.permissionDeniedErrorTitle",
        defaultMessage: "Permission denied",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 15
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        "data-test-subj": "missingPrivilegesPromptMessage",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 13
        }
      }, requiredFleetRole ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.pagePermissionDeniedErrorMessage",
        defaultMessage: "You are not authorized to access that page. It requires the {roleName} Kibana privilege for Fleet.",
        values: {
          roleName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 75,
              columnNumber: 31
            }
          }, requiredFleetRole)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 17
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.permissionDeniedErrorMessage",
        defaultMessage: "You are not currently authorized to access {callingApplication}. For access, your Kibana role must include the {roleName2} or {roleName1} privilege for {callingApplication}. {guideLink}",
        values: {
          callingApplication,
          roleName1: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 84,
              columnNumber: 32
            }
          }, "\"All\""),
          roleName2: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 85,
              columnNumber: 32
            }
          }, "\"Read\""),
          guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.links.fleet.roleAndPrivileges,
            target: "_blank",
            external: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 87,
              columnNumber: 23
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.rolesAndPrivilegesGuideLink",
            defaultMessage: "Learn more.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 92,
              columnNumber: 25
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 17
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.permissionsRequestErrorMessageTitle",
      defaultMessage: "Unable to check permissions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }),
    error: _i18n.i18n.translate('xpack.fleet.permissionsRequestErrorMessageDescription', {
      defaultMessage: 'There was a problem checking Fleet permissions'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  });
});