"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCloudFormationPropsFromPackagePolicy = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AWS_ACCOUNT_TYPE = 'aws.account_type';

/**
 * Get the cloud formation template url from a package policy
 * It looks for a config with a cloud_formation_template_url object present in
 * the enabled inputs of the package policy
 */
const getCloudFormationPropsFromPackagePolicy = packagePolicy => {
  var _packagePolicy$inputs, _packagePolicy$inputs2, _packagePolicy$inputs3, _packagePolicy$inputs4, _packagePolicy$inputs5, _packagePolicy$inputs6, _packagePolicy$inputs7;
  const templateUrl = packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$inputs = packagePolicy.inputs) === null || _packagePolicy$inputs === void 0 ? void 0 : _packagePolicy$inputs.reduce((accInput, input) => {
    var _input$config;
    if (accInput !== '') {
      return accInput;
    }
    if (input !== null && input !== void 0 && input.enabled && input !== null && input !== void 0 && (_input$config = input.config) !== null && _input$config !== void 0 && _input$config.cloud_formation_template_url) {
      return input.config.cloud_formation_template_url.value;
    }
    return accInput;
  }, '');
  const awsAccountType = packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$inputs2 = packagePolicy.inputs) === null || _packagePolicy$inputs2 === void 0 ? void 0 : (_packagePolicy$inputs3 = _packagePolicy$inputs2.find(input => input.enabled)) === null || _packagePolicy$inputs3 === void 0 ? void 0 : (_packagePolicy$inputs4 = _packagePolicy$inputs3.streams) === null || _packagePolicy$inputs4 === void 0 ? void 0 : (_packagePolicy$inputs5 = _packagePolicy$inputs4[0]) === null || _packagePolicy$inputs5 === void 0 ? void 0 : (_packagePolicy$inputs6 = _packagePolicy$inputs5.vars) === null || _packagePolicy$inputs6 === void 0 ? void 0 : (_packagePolicy$inputs7 = _packagePolicy$inputs6[AWS_ACCOUNT_TYPE]) === null || _packagePolicy$inputs7 === void 0 ? void 0 : _packagePolicy$inputs7.value;
  return {
    templateUrl: templateUrl !== '' ? templateUrl : undefined,
    awsAccountType
  };
};
exports.getCloudFormationPropsFromPackagePolicy = getCloudFormationPropsFromPackagePolicy;