"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstalledIntegrationsSearchBar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _use_url_filters = require("../hooks/use_url_filters");
var _installed_integration_action_menu = require("./installed_integration_action_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/installed_integrations/components/installed_integrations_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SEARCH_DEBOUNCE_MS = 250;
const InstalledIntegrationsSearchBar = ({
  filters,
  countPerStatus,
  customIntegrationsCount,
  selectedItems
}) => {
  const addUrlFilter = (0, _use_url_filters.useAddUrlFilters)();
  const theme = (0, _eui.useEuiTheme)();
  const [searchTerms, setSearchTerms] = (0, _react.useState)(filters.q);
  (0, _useDebounce.default)(() => {
    addUrlFilter({
      q: searchTerms
    });
  }, SEARCH_DEBOUNCE_MS, [searchTerms]);
  const statuses = (0, _react.useMemo)(() => [{
    iconType: 'warning',
    iconColor: theme.euiTheme.colors.textWarning,
    status: 'upgrade_available',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.upgradeAvailableFilterLabel",
      defaultMessage: "Upgrade",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    })
  }, {
    iconType: 'error',
    iconColor: theme.euiTheme.colors.textDanger,
    status: 'upgrade_failed',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.upgradeFailerFilterLabel",
      defaultMessage: "Upgrade failed",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    })
  }, {
    iconType: 'error',
    iconColor: theme.euiTheme.colors.textDanger,
    status: 'install_failed',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.installFailerFilterLabel",
      defaultMessage: "Install failed",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    })
  }], [theme]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    defaultValue: filters.q,
    onChange: e => setSearchTerms(e.target.value),
    placeholder: _i18n.i18n.translate('xpack.fleet.serachBarPlaceholder', {
      defaultMessage: 'Search'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }, statuses.map(item => {
    var _filters$installation, _countPerStatus$item$;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: item.iconType,
      iconSide: "left",
      css: (0, _react2.css)`
                  .euiIcon {
                    color: ${item.iconColor};
                  }
                `,
      hasActiveFilters: (_filters$installation = filters.installationStatus) === null || _filters$installation === void 0 ? void 0 : _filters$installation.includes(item.status),
      numFilters: (_countPerStatus$item$ = countPerStatus[item.status]) !== null && _countPerStatus$item$ !== void 0 ? _countPerStatus$item$ : 0,
      onClick: () => {
        var _filters$installation2;
        if (!((_filters$installation2 = filters.installationStatus) !== null && _filters$installation2 !== void 0 && _filters$installation2.includes(item.status))) {
          addUrlFilter({
            installationStatus: [item.status]
          });
        } else {
          addUrlFilter({
            installationStatus: []
          });
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 15
      }
    }, item.label);
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    hasActiveFilters: filters.customIntegrations,
    numFilters: customIntegrationsCount,
    onClick: () => {
      if (filters.customIntegrations) {
        addUrlFilter({
          customIntegrations: undefined
        });
      } else {
        addUrlFilter({
          customIntegrations: true
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.customFilterLabel",
    defaultMessage: "Custom",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_installed_integration_action_menu.InstalledIntegrationsActionMenu, {
    selectedItems: selectedItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }))));
};
exports.InstalledIntegrationsSearchBar = InstalledIntegrationsSearchBar;