"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseYamlChangelog = exports.getBreakingChanges = exports.formatChangelog = exports.ChangeType = void 0;
var _jsYaml = require("js-yaml");
var _gte = _interopRequireDefault(require("semver/functions/gte"));
var _lte = _interopRequireDefault(require("semver/functions/lte"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ChangeType = exports.ChangeType = /*#__PURE__*/function (ChangeType) {
  ChangeType["Enhancement"] = "enhancement";
  ChangeType["BreakingChange"] = "breaking-change";
  ChangeType["BugFix"] = "bugfix";
  return ChangeType;
}({});
const formatChangelog = parsedChangelog => {
  if (!parsedChangelog) return '';
  return parsedChangelog.reduce((acc, val) => {
    acc += `Version: ${val.version}\nChanges:\n  Type: ${val.changes[0].type}\n  Description: ${val.changes[0].description}\n  Link: ${val.changes[0].link}\n\n`;
    return acc;
  }, '');
};
exports.formatChangelog = formatChangelog;
const parseYamlChangelog = (changelogText, latestVersion, currentVersion) => {
  const parsedChangelog = changelogText ? (0, _jsYaml.load)(changelogText) : [];
  if (!currentVersion) return parsedChangelog.filter(e => (0, _lte.default)(e.version, latestVersion));
  return parsedChangelog.filter(e => (0, _lte.default)(e.version, latestVersion) && (0, _gte.default)(e.version, currentVersion));
};
exports.parseYamlChangelog = parseYamlChangelog;
const getBreakingChanges = changelog => {
  return changelog.reduce((acc, entry) => {
    const breakingChanges = entry.changes.filter(change => {
      return change.type === ChangeType.BreakingChange;
    });
    if (breakingChanges.length > 0) {
      return [...acc, {
        ...entry,
        changes: breakingChanges
      }];
    }
    return acc;
  }, []);
};
exports.getBreakingChanges = getBreakingChanges;