"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _output_health = require("../edit_output_flyout/output_health");
var _services = require("../../../../services");
var _badges = require("./badges");
var _integration_sync_status = require("./integration_sync_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/outputs_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NameFlexItemWithMaxWidth = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 250px;
`;

// Allow child to be truncated
const FlexGroupWithMinWidth = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  min-width: 0px;
`;
function displayOutputType(type) {
  switch (type) {
    case 'elasticsearch':
      return _i18n.i18n.translate('xpack.fleet.settings.outputsTable.elasticsearchTypeLabel', {
        defaultMessage: 'Elasticsearch'
      });
    case 'remote_elasticsearch':
      return _i18n.i18n.translate('xpack.fleet.settings.outputsTable.remoteElasticsearchTypeLabel', {
        defaultMessage: 'Remote Elasticsearch'
      });
    default:
      return type;
  }
}
const OutputsTable = ({
  outputs,
  deleteOutput
}) => {
  const authz = (0, _hooks.useAuthz)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    enableSyncIntegrationsOnRemote
  } = _services.ExperimentalFeaturesService.get();
  const {
    cloud
  } = (0, _hooks.useStartServices)();
  const enableSyncIntegrations = enableSyncIntegrationsOnRemote && _hooks.licenseService.isEnterprise() && !(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled);
  const columns = (0, _react.useMemo)(() => {
    return [{
      render: output => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(NameFlexItemWithMaxWidth, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        title: output.name,
        className: `eui-textTruncate`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 15
        }
      }, output.name)), output.is_preconfigured && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.fleet.settings.outputsTable.managedTooltip', {
          defaultMessage: 'This output is managed outside of Fleet.'
        }),
        type: "lock",
        size: "m",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 17
        }
      }))),
      width: '288px',
      name: _i18n.i18n.translate('xpack.fleet.settings.outputsTable.nameColumnTitle', {
        defaultMessage: 'Name'
      })
    }, {
      width: '172px',
      render: output => displayOutputType(output.type),
      name: _i18n.i18n.translate('xpack.fleet.settings.outputsTable.typeColumnTitle', {
        defaultMessage: 'Type'
      })
    }, {
      truncateText: true,
      render: output => /*#__PURE__*/_react.default.createElement(FlexGroupWithMinWidth, {
        direction: "column",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 11
        }
      }, (output.hosts || []).map(host => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: host,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        title: host,
        className: `eui-textTruncate`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 17
        }
      }, host)))),
      name: _i18n.i18n.translate('xpack.fleet.settings.outputsTable.hostColumnTitle', {
        defaultMessage: 'Hosts'
      })
    }, {
      render: output => {
        return output !== null && output !== void 0 && output.id && output.type === 'remote_elasticsearch' ? /*#__PURE__*/_react.default.createElement(_output_health.OutputHealth, {
          output: output,
          showBadge: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 120,
            columnNumber: 13
          }
        }) : null;
      },
      name: _i18n.i18n.translate('xpack.fleet.settings.outputsTable.statusColumnTitle', {
        defaultMessage: 'Status'
      })
    }, ...(enableSyncIntegrations ? [{
      render: output => /*#__PURE__*/_react.default.createElement(_integration_sync_status.IntegrationSyncStatus, {
        output: output,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 43
        }
      }),
      name: _i18n.i18n.translate('xpack.fleet.settings.outputsTable.integrationSyncColumnTitle', {
        defaultMessage: 'Integration syncing'
      })
    }] : []), {
      render: output => /*#__PURE__*/_react.default.createElement(_badges.DefaultBadges, {
        output: output,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 37
        }
      }),
      width: '200px',
      name: _i18n.i18n.translate('xpack.fleet.settings.outputSection.defaultColumnTitle', {
        defaultMessage: 'Default'
      })
    }, {
      width: '68px',
      render: output => {
        const isDeleteVisible = !output.is_default && !output.is_default_monitoring && !output.is_preconfigured && authz.fleet.allSettings;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          justifyContent: "flexEnd",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 154,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 155,
            columnNumber: 15
          }
        }, isDeleteVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          color: "text",
          iconType: "trash",
          onClick: () => deleteOutput(output),
          title: _i18n.i18n.translate('xpack.fleet.settings.outputSection.deleteButtonTitle', {
            defaultMessage: 'Delete'
          }),
          "aria-label": _i18n.i18n.translate('xpack.fleet.settings.outputSection.deleteButtonTitle', {
            defaultMessage: 'Delete'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 157,
            columnNumber: 19
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 173,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          color: "text",
          iconType: "pencil",
          href: getHref('settings_edit_outputs', {
            outputId: output.id
          }),
          title: _i18n.i18n.translate('xpack.fleet.settings.outputSection.editButtonTitle', {
            defaultMessage: 'Edit'
          }),
          "aria-label": _i18n.i18n.translate('xpack.fleet.settings.outputSection.editButtonTitle', {
            defaultMessage: 'Edit'
          }),
          "data-test-subj": "editOutputBtn",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 174,
            columnNumber: 17
          }
        })));
      },
      name: _i18n.i18n.translate('xpack.fleet.settings.outputSection.actionsColumnTitle', {
        defaultMessage: 'Actions'
      })
    }];
  }, [deleteOutput, getHref, authz.fleet.allSettings, enableSyncIntegrations]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: outputs,
    "data-test-subj": "settingsOutputsTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 10
    }
  });
};
exports.OutputsTable = OutputsTable;